# History Usage Guidelines

Creating an audit requires setting many different fields. Below, we will provide guidelines for each field, then go through some examples. Starred fields are required when submitting an audit.

### \*Action
If possible, this field should be a CRUD verb (`create`, `read`, `update`, `destroy`). However, when it would not make sense to choose one one of these verbs, feel free to choose an action that adequately describes your audit. This field is required.

### \*User Type
Represents the type of user that is performing the action being audited, and should always be suffixed with `_user`. This field is required.

### \*User ID
The ID of the user who performed the action. This field is required.

### Resource Type
The resource upon which the action occurred and is being audited.

### Resource ID
The ID of the resource upon which the action was performed.

### Description
A description of the audit should _only_ be provided if there is any outstanding information that is not conveyed by the audit itself and has a maximum length of 1024 characters. This field should be left empty for most audits.

### \*Expiry
The number of seconds an audit should persist for before being removed. This field is required and must be greater than 0.

### Created At
The time that this audit was created, will almost always be `Time.now`.

### Changes
This field is an array of {`attribute`, `old_value`, `new_value`} objects that represents one or more attributes of the resource whose state is being audited. It can support new value, updated value, or deleted values by specifying only the new value, both the old and new value, or only the old value.

##### Attribute
This field represents the attribute that was changed and is being audited.

##### Old Value
The value of the attribute before the change was made. If there was no old value, this field can be left blank.

##### New Value
The value of the attribute after the change was made. If there is no old value, this field can be left blank.

# Example Cases

### 1. User Bio Changes
The user team would like to audit when users change their bio. Here is what an audit might look like:

**action**: `update`. Since we can stick with a CRUD verb, we will.

**user_type**: `twitch_user`. This is a user on Twitch updating their bio, so we want to go with `twitch_user` as the `user_type`.

**user_id**: `1234`. This is simply the user's ID.

**resource_type**: `twitch_user`. A user updating their bio is performing the action on themselves, the user, so the correct resource type is `twitch_user` here.

**reource_id**: `1234`. The ID of the resource is the ID of the user, which in this case is `1234`.

**description**: `<blank>`. There isn't any extra information we need to convey in this audit, so we pass in an empty description.

**expiry**: `31622400`. We aren't too worried about maintaining this audit, so we can set it to expire after 1 year (`31622400` seconds is equivalent to 1 year).

**created_at**: `2017-02-22T15:04:05.000Z`. The current time.

**changes**:

    [{
      "attribute": "bio",
      "old_value": "this is my old bio",
      "new_value": "this is my new bio"
    }]

`changes` is an array representing the changes that occurred. Here, we record that the `attribute` being changed is the user's bio, and what the old and new value were.

### 2. Admin Deleting a User
The support team would like to record an audit when a team member deletes a user's account. Here is what an audit might look like:

**action**: `delete`. Since we can stick with a CRUD verb, we will.

**user_type**: `ldap_user`. Recall that this is the type of user performing the action. We are recording an admin deleting a user, so it is an admin performing the action. Thus, the `user_type` here is `ldap_user`.

**user_id**: `cdym`. This is the ID of the user performing the action.

**resource_type**: `twitch_user`. The resource being acted upon is the user account being deleted, so it is a `twitch_user`.

**resource_id**: `1234`. This is the ID of the user being deleted.

**description**: `"Deleting this account due to copyright violations"`. We are leaving a description to explain why this account is being deleted, which is important information that doesn't fit into any other fields of an audit.

**expiry**: `157784760`. We want to keep this audit around for a while, so we set it to expire after 5 years. (Note that we could have also left this field blank to let it default to 5 years).

**created_at**: `2017-02-22T15:04:05.000Z`. The current time.

**changes**:

    [{
      "attribute": "user-account",
      "old_value": "active",
      "new_value": "deleted"
    }]

Here, we record that the user account went from one that was existing and active, to one that was deleted.
