package queue

import "time"

// DeleteUserMessage contains
// - id - UserID of the user whose data needs to be deleted
// timestamp - request timestamp
type DeleteUserMessage struct {
	UserID    string    `json:"user_id"`
	Timestamp time.Time `json:"timestamp"`
}

// GenerateUserReportMessage contains
// - id - UserID of the user for which data report needs to be generated
// timestamp - request timestamp
type GenerateUserReportMessage struct {
	UserID    string    `json:"user_id"`
	Timestamp time.Time `json:"timestamp"`
}
