#!/bin/bash -e

[[ -e "$ROLE_ARN" ]] && echo '$ROLE_ARN is required' && exit 1

CREDS=(`aws sts assume-role \
  --role-arn "$ROLE_ARN" \
  --role-session-name "jenkins-session" \
  --query '[Credentials.AccessKeyId,Credentials.SecretAccessKey,Credentials.SessionToken]' \
  --output "text" \
  --duration-seconds 900`)

export AWS_ACCESS_KEY_ID=${CREDS[0]}
export AWS_SECRET_ACCESS_KEY=${CREDS[1]}
export AWS_SESSION_TOKEN=${CREDS[2]}
