package main

import (
	"context"
	"flag"
	"os"

	"code.justin.tv/foundation/history-service/internal/deployutils/ecs"
	"code.justin.tv/foundation/history-service/internal/deployutils/lambda"
	"github.com/google/subcommands"
	"github.com/sirupsen/logrus"
)

func main() {

	lgr := logrus.New()

	subcommands.Register(subcommands.HelpCommand(), "")
	subcommands.Register(subcommands.FlagsCommand(), "")
	subcommands.Register(subcommands.CommandsCommand(), "")

	subcommands.Register(&ecs.UpdateTaskDef{
		Logger: lgr,
	}, "ecs")
	subcommands.Register(&lambda.UpdateLambdaFuncCmd{
		Logger: lgr,
	}, "lambda")
	subcommands.Register(&lambda.S3UploadLambdaFuncCmd{
		Logger: lgr,
	}, "s3-upload-lambda")

	subcommands.Register(&lambda.S3UploadLambdaFuncCmd{
		Logger: lgr,
	}, "s3-upload-lambda")

	subcommands.Register(&lambda.UpdateLambdaFuncCmd{
		Logger: lgr,
	}, "lambda")

	flag.Parse()

	os.Exit(int(subcommands.Execute(context.Background())))
}
