# Deploy to ECR IAM
resource "aws_iam_role" "deploy" {
  name               = "${local.resource_prefix}-deploy"
  assume_role_policy = "${data.aws_iam_policy_document.deploy-arp.json}"
}

data "aws_iam_policy_document" "deploy-arp" {
  statement = {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "AWS"
      identifiers = ["${var.allowed_deployment_arns}"]
    }
  }
}

data "aws_ecr_repository" "app" {
  name = "${local.resource_prefix}"
}

resource "aws_iam_role_policy" "deploy" {
  role   = "${aws_iam_role.deploy.id}"
  policy = "${data.aws_iam_policy_document.deploy-p.json}"
}

data "aws_iam_policy_document" "deploy-p" {
  statement {
    actions = [
      "ecs:RegisterTaskDefinition",
      "ecs:UpdateService",
      "ecr:DescribeRepositories",
      "ecr:GetAuthorizationToken",
    ]

    resources = [
      "*",
    ]
  }

  statement {
    actions = [
      "ecr:*",
    ]

    resources = [
      "${data.aws_ecr_repository.app.arn}",
    ]
  }

  statement {
    actions = [
      "iam:PassRole",
    ]

    resources = [
      "${var.ecs_delete_user_task_role_arn}",
      "${var.ecs_delete_user_exec_role_arn}",
      "${var.ecs_generate_user_report_task_role_arn}",
      "${var.ecs_generate_user_report_exec_role_arn}",
    ]
  }

  statement {
    actions = [
      "s3:*",
    ]

    resources = [
      "${aws_s3_bucket.lambdas.arn}*",
      "${aws_s3_bucket.lambdas.arn}/*",
    ]
  }

  statement {
    actions = [
      "lambda:UpdateFunctionCode",
    ]

    resources = [
      "${var.deployable_lambda_arns}",
    ]
  }
}
