resource "aws_dynamodb_table" "report-status" {
  name           = "${local.resource_prefix}-user-report-status"
  read_capacity  = "${local.read_capacity}"
  write_capacity = "${local.write_capacity}"
  hash_key       = "user_id"
  range_key      = "timestamp"

  attribute {
    name = "user_id"
    type = "S"
  }

  attribute {
    name = "timestamp"
    type = "N"
  }

  attribute {
    name = "requester"
    type = "S"
  }

  ttl {
    attribute_name = "expires_at"
    enabled        = true
  }

  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  tags {
    Environment = "${var.environment}"
  }

  //global_secondary_index
  global_secondary_index {
    name            = "ReportsByRequesterGSI"
    hash_key        = "requester"
    range_key       = "timestamp"
    write_capacity  = "${local.write_capacity}"
    read_capacity   = "${local.read_capacity}"
    projection_type = "ALL"
  }

  server_side_encryption {
    enabled = true
  }
}

resource "aws_dynamodb_table" "pending-user-deletions" {
  name           = "${local.resource_prefix}-pending-user-deletion"
  read_capacity  = "${local.read_capacity}"
  write_capacity = "${local.write_capacity}"
  hash_key       = "user_id"

  attribute {
    name = "user_id"
    type = "S"
  }

  attribute {
    name = "requester"
    type = "S"
  }

  ttl {
    attribute_name = "expires_at"
    enabled        = true
  }

  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  server_side_encryption {
    enabled = true
  }

  //global_secondary_index
  global_secondary_index {
    name            = "ScheduledDeletesByRequesterGSI"
    hash_key        = "requester"
    write_capacity  = "${local.write_capacity}"
    read_capacity   = "${local.read_capacity}"
    projection_type = "ALL"
  }

  tags {
    Environment = "${var.environment}"
  }
}
