module "dummy_go_lambda" {
  source = "../dummy-go-lambda"
}

resource "aws_lambda_function" "delete-user" {
  function_name = "${local.resource_prefix}-delete-user"
  role          = "${aws_iam_role.lambda-delete-user.arn}"
  handler       = "lambda-delete-user"
  runtime       = "go1.x"
  filename      = "${module.dummy_go_lambda.filename}"
  timeout       = "${local.lambda_default_timeout}"

  vpc_config {
    subnet_ids         = "${var.twitch_subnets}"
    security_group_ids = "${var.security_group}"
  }

  environment {
    variables = {
      "ENVIRONMENT"         = "${var.environment}"
      "REGION"              = "${var.region}"
      "QUEUE_URL"           = "${aws_sqs_queue.delete-user.id}"
      "CLUSTER_NAME"        = "${aws_ecs_cluster.gdpr.arn}"
      "TASK_DEFINITION_ARN" = "arn:aws:ecs:us-west-2:${local.aws_account_id}:task-definition/${local.resource_prefix}-delete-user"
      "SUBNETS"             = "${join(",", var.twitch_subnets)}"
    }
  }

  lifecycle {
    ignore_changes = [
      "filename",
      "last_modified",
    ]
  }
}

resource "aws_lambda_event_source_mapping" "delete-user" {
  event_source_arn  = "${aws_dynamodb_table.pending-user-deletions.stream_arn}"
  function_name     = "${aws_lambda_function.delete-user.arn}"
  starting_position = "LATEST"
}

resource "aws_lambda_function" "generate-user-report" {
  function_name = "${local.resource_prefix}-generate-user-report"
  role          = "${aws_iam_role.lambda-generate-user-report.arn}"
  handler       = "lambda-generate-user-report"
  runtime       = "go1.x"
  filename      = "${module.dummy_go_lambda.filename}"
  timeout       = "${local.lambda_default_timeout}"

  vpc_config {
    subnet_ids         = "${var.twitch_subnets}"
    security_group_ids = "${var.security_group}"
  }

  environment {
    variables = {
      "ENVIRONMENT"         = "${var.environment}"
      "REGION"              = "${var.region}"
      "QUEUE_URL"           = "${aws_sqs_queue.generate-user-report.id}"
      "CLUSTER_NAME"        = "${aws_ecs_cluster.gdpr.arn}"
      "TASK_DEFINITION_ARN" = "arn:aws:ecs:us-west-2:${local.aws_account_id}:task-definition/${local.resource_prefix}-generate-user-report"
      "SUBNETS"             = "${join(",", var.twitch_subnets)}"
    }
  }

  lifecycle {
    ignore_changes = [
      "filename",
      "last_modified",
    ]
  }
}

resource "aws_lambda_event_source_mapping" "generate-user-report" {
  event_source_arn  = "${aws_dynamodb_table.report-status.stream_arn}"
  function_name     = "${aws_lambda_function.generate-user-report.arn}"
  starting_position = "LATEST"
}

resource "aws_lambda_function" "hard-delete-event-handler" {
  function_name = "${local.resource_prefix}-hard-delete-event-handler"
  role          = "${aws_iam_role.lambda-hard-delete-event-handler.arn}"
  handler       = "lambda-hard-delete-event-handler"
  runtime       = "go1.x"
  filename      = "${module.dummy_go_lambda.filename}"
  timeout       = "${local.lambda_default_timeout}"

  vpc_config {
    subnet_ids         = "${var.twitch_subnets}"
    security_group_ids = "${var.security_group}"
  }

  environment {
    variables = {
      "ENVIRONMENT"                      = "${var.environment}"
      "QUEUE_URL"                        = "${aws_sqs_queue.user-service-hard-delete.id}"
      "REGION"                           = "${var.region}"
      "PENDING_USER_DELETION_TABLE_NAME" = "${aws_dynamodb_table.pending-user-deletions.name}"
      "TTL"                              = "${local.user_deletion_ttl}"
    }
  }

  lifecycle {
    ignore_changes = [
      "filename",
      "last_modified",
    ]
  }
}

resource "aws_lambda_event_source_mapping" "hard-delete-event-handler" {
  event_source_arn = "${aws_sqs_queue.user-service-hard-delete.arn}"
  function_name    = "${aws_lambda_function.hard-delete-event-handler.arn}"
}
