resource "aws_s3_bucket" "user-reports" {
  bucket = "${local.resource_prefix}-user-reports"
  acl    = "private"

  tags = {
    Environment = "${var.environment}"
  }

  lifecycle_rule {
    id      = "cleanup-user-reports-after-7-days"
    enabled = true

    prefix = "/"

    tags {
      "rule"      = "cleanup-user-reports-after-7-days"
      "autoclean" = "true"
    }

    expiration {
      days = 7
    }
  }
}
