resource "aws_sqs_queue" "delete-user" {
  name                       = "${local.resource_prefix}-delete-user"
  message_retention_seconds  = "${local.sqs_message_retention_seconds}"
  visibility_timeout_seconds = "${local.sqs_message_visibility_timeout_seconds}"
  kms_master_key_id          = "${aws_kms_alias.sqs.arn}"

  tags {
    Environment = "${var.environment}"
  }
}

resource "aws_sqs_queue" "generate-user-report" {
  name                       = "${local.resource_prefix}-generate-user-report"
  message_retention_seconds  = "${local.sqs_message_retention_seconds}"
  visibility_timeout_seconds = "${local.sqs_message_visibility_timeout_seconds}"
  kms_master_key_id          = "${aws_kms_alias.sqs.arn}"

  tags {
    Environment = "${var.environment}"
  }
}

resource "aws_sqs_queue" "user-service-hard-delete" {
  name                       = "${local.resource_prefix}-user-service-hard-delete"
  message_retention_seconds  = "${local.sqs_message_retention_seconds}"
  visibility_timeout_seconds = "${local.sqs_message_visibility_timeout_seconds}"
  kms_master_key_id          = "${aws_kms_alias.sqs.arn}"

  tags {
    Environment = "production"
    TopicARN    = "${var.user_service_hard_delete_topic}"
  }
}

resource "aws_sns_topic_subscription" "user-service-hard-delete" {
  topic_arn = "${var.user_service_hard_delete_topic}"
  protocol  = "sqs"
  endpoint  = "${aws_sqs_queue.user-service-hard-delete.arn}"
}
