variable "environment" {}
variable "region" {}
variable "resource_prefix" {}
variable "user_audits_table_arn" {}
variable "elasticsearch_domain_arn" {}

variable "user_service_hard_delete_topic" {}

variable "twitch_subnets" {
  type = "list"
}

variable "security_group" {
  type = "list"
}

variable "gdpr_service_allowed_arn" {
  type = "list"
}

data "aws_caller_identity" "current" {}

locals {
  aws_account_id = "${data.aws_caller_identity.current.account_id}"

  resource_prefix = "${var.resource_prefix}-${var.environment}"

  root_arn = "arn:aws:iam::${local.aws_account_id}:root"

  read_capacity  = 10
  write_capacity = 10

  # lambda configuration 
  # ttl for user deletion after receiving hard delete signal
  # i.e. 3 year in seconds
  user_deletion_ttl = 94608000

  //hide the sqs messages for 15 minutes
  sqs_message_visibility_timeout_seconds = 900
  sqs_message_retention_seconds          = 1209600

  lambda_default_timeout = 300
}
