resource "aws_s3_bucket" "app" {
  bucket = "${local.prefix}-backups"
  acl    = "private"
}

resource "aws_iam_role" "firehose-backups" {
  name               = "${local.prefix}-firehose-backups"
  assume_role_policy = "${data.aws_iam_policy_document.firehose-arp.json}"
}

resource "aws_iam_role_policy" "firehose-backups" {
  role   = "${aws_iam_role.firehose-backups.id}"
  policy = "${data.aws_iam_policy_document.firehose-backups-rp.json}"
}

data "aws_iam_policy_document" "firehose-backups-rp" {
  statement {
    actions = [
      "s3:AbortMultipartUpload",
      "s3:GetBucketLocation",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:ListBucketMultipartUploads",
      "s3:PutObject",
    ]

    resources = [
      "${aws_s3_bucket.app.arn}",
      "${aws_s3_bucket.app.arn}/*",
    ]

    effect = "Allow"
  }

  statement {
    actions = [
      "logs:CreateLogStream",
      "logs:PutLogEvents",
    ]

    resources = [
      "${aws_cloudwatch_log_stream.backups.arn}",
    ]

    effect = "Allow"
  }
}
