resource "aws_iam_role" "ingest" {
  name               = "${local.prefix}-ingest"
  assume_role_policy = "${data.aws_iam_policy_document.ingest-arp.json}"
}

data "aws_iam_policy_document" "ingest-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type = "AWS"

      identifiers = [
        "${var.ingest_allowed_arns}",
        "${local.root_arn}",
      ]
    }

    effect = "Allow"
  }
}

resource "aws_iam_role_policy" "ingest" {
  role   = "${aws_iam_role.ingest.id}"
  policy = "${data.aws_iam_policy_document.ingest-rp.json}"
}

data "aws_iam_policy_document" "ingest-rp" {
  statement {
    actions = [
      "firehose:DescribeDeliveryStream",
      "firehose:ListDeliveryStreams",
      "firehose:PutRecord",
      "firehose:PutRecordBatch",
    ]

    resources = [
      "${aws_kinesis_firehose_delivery_stream.app.arn}",
    ]

    effect = "Allow"
  }

  statement {
    actions = [
      "kinesis:PutRecord",
      "kinesis:PutRecords",
    ]

    resources = [
      "${aws_kinesis_stream.data-stream.arn}",
    ]

    effect = "Allow"
  }
}
