resource "aws_kinesis_stream" "data-stream" {
  name             = "${local.prefix}-stream"
  shard_count      = "${var.stream_shard_count}"
  retention_period = 72

  shard_level_metrics = [
    "ReadProvisionedThroughputExceeded",
    "WriteProvisionedThroughputExceeded",
  ]

  tags {
    Environment         = "${var.environment}"
    Lambda_consumer_arn = "${aws_lambda_function.stream-ingest.arn}"
  }

  lifecycle {
    ignore_changes = [
      "shard_count",
    ]
  }
}

resource "aws_lambda_event_source_mapping" "data-stream" {
  batch_size        = "${var.stream_batch_size}"
  event_source_arn  = "${aws_kinesis_stream.data-stream.arn}"
  enabled           = true
  function_name     = "${aws_lambda_function.stream-ingest.arn}"
  starting_position = "LATEST"
}

data "aws_iam_policy_document" "stream-consumer-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type = "Service"

      identifiers = [
        "firehose.amazonaws.com",
      ]
    }
  }
}

resource "aws_iam_role" "consumer" {
  name               = "${local.prefix}-stream-consumer"
  assume_role_policy = "${data.aws_iam_policy_document.stream-consumer-arp.json}"
}

resource "aws_iam_role_policy_attachment" "consumer" {
  role       = "${aws_iam_role.consumer.id}"
  policy_arn = "${data.aws_iam_policy.kinesis-execution.arn}"
}
