resource "aws_kinesis_firehose_delivery_stream" "app" {
  name        = "${local.prefix}"
  destination = "elasticsearch"

  kinesis_source_configuration {
    kinesis_stream_arn = "${aws_kinesis_stream.data-stream.arn}"
    role_arn           = "${aws_iam_role.consumer.arn}"
  }

  s3_configuration {
    role_arn           = "${aws_iam_role.firehose-backups.arn}"
    bucket_arn         = "${aws_s3_bucket.app.arn}"
    buffer_size        = 10
    buffer_interval    = 400
    compression_format = "GZIP"

    cloudwatch_logging_options {
      enabled         = true
      log_group_name  = "${aws_cloudwatch_log_group.backups.name}"
      log_stream_name = "${aws_cloudwatch_log_stream.backups.name}"
    }
  }

  elasticsearch_configuration {
    domain_arn            = "${aws_elasticsearch_domain.app.arn}"
    role_arn              = "${aws_iam_role.firehose-elasticsearch.arn}"
    index_name            = "history"
    index_rotation_period = "NoRotation"
    type_name             = "audits"
    s3_backup_mode        = "AllDocuments"

    cloudwatch_logging_options {
      enabled         = true
      log_group_name  = "${aws_cloudwatch_log_group.elasticsearch.name}"
      log_stream_name = "${aws_cloudwatch_log_stream.elasticsearch.name}"
    }
  }
}
