resource "aws_iam_role" "read" {
  name               = "${local.prefix}-read"
  assume_role_policy = "${data.aws_iam_policy_document.read-arp.json}"
}

data "aws_iam_policy_document" "read-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type = "AWS"

      identifiers = [
        "${local.root_arn}",
        "${var.read_allowed_arns}",
      ]
    }

    effect = "Allow"
  }
}

resource "aws_iam_role_policy" "read" {
  role   = "${aws_iam_role.read.id}"
  policy = "${data.aws_iam_policy_document.read-rp.json}"
}

data "aws_iam_policy_document" "read-rp" {
  statement {
    actions = [
      "es:ESHttpGet",
      "es:ESHttpHead",
      "es:ESHttpPost",
    ]

    resources = [
      "${aws_elasticsearch_domain.app.arn}/history*/_search",
      "${aws_elasticsearch_domain.app.arn}/auditor*/_search",
    ]

    effect = "Allow"
  }
}
