variable "environment" {}
variable "aws_account_id" {}
variable "es_dedicated_master_enabled" {}
variable "es_instance_type" {}
variable "es_instance_count" {}
variable "es_master_instance_type" {}
variable "es_master_instance_count" {}
variable "es_volume_size" {}
variable "es_zone_awareness_enabled" {}

variable "ingest_allowed_arns" {
  type = "list"
}

variable "read_allowed_arns" {
  type = "list"
}

variable "table_history_write_min_capacity" {}
variable "table_history_write_max_capacity" {}

variable "twitch_subnet" {
  type = "list"
}

variable "security_group" {
  type = "list"
}

variable "stream_shard_count" {}
variable "stream_batch_size" {}
variable "resource_prefix" {}

locals {
  prefix   = "${var.resource_prefix}-${var.environment}"
  es_arn   = "arn:aws:es:us-west-2:${var.aws_account_id}:domain/${local.prefix}/*"
  root_arn = "arn:aws:iam::${var.aws_account_id}:root"

  read_capacity                           = 10
  write_capacity                          = 10
  table_write_target_capacity_utilization = 70
}

output "elasticsearch_domain_arn" {
  value = "${aws_elasticsearch_domain.app.arn}"
}

output "audits_table_arn" {
  value = "${aws_dynamodb_table.history.arn}"
}
