// Create new IAM role that has a trust relationship with the ElasticBeanstalk.
//
resource "aws_iam_role" "aws-elasticbeanstalk-service-role" {
  name = "aws-elasticbeanstalk-service-role"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "",
      "Effect": "Allow",
      "Principal": {
        "Service": "elasticbeanstalk.amazonaws.com"
      },
      "Action": "sts:AssumeRole",
      "Condition": {
        "StringEquals": {
          "sts:ExternalId": "elasticbeanstalk"
        }
      }
    }
  ]
}
EOF
}

// Grant the aws-elasticbeanstalk-service-role AWSElasticBeanstalkEnhancedHealth permissions.
//
resource "aws_iam_role_policy_attachment" "aws-elasticbeanstalk-service-enhanced-health" {
  role       = "${aws_iam_role.aws-elasticbeanstalk-service-role.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkEnhancedHealth"
}

// Grant the aws-elasticbeanstalk-service-role AWSElasticBeanstalkService permissions.
//
resource "aws_iam_role_policy_attachment" "aws-elasticbeanstalk-service-beanstalk" {
  role       = "${aws_iam_role.aws-elasticbeanstalk-service-role.name}"
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSElasticBeanstalkService"
}

// Grant the aws-elasticbeanstalk-service-role role ability to monitor the health of the app.
//
resource "aws_iam_role_policy" "custom-health-policy" {
  name = "custom-health-policy"
  role = "${aws_iam_role.aws-elasticbeanstalk-service-role.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "elasticloadbalancing:DescribeInstanceHealth",
        "ec2:DescribeInstances",
        "ec2:DescribeInstanceStatus",
        "ec2:GetConsoleOutput",
        "ec2:AssociateAddress",
        "ec2:DescribeAddresses",
        "ec2:DescribeSecurityGroups",
        "sqs:GetQueueAttributes",
        "sqs:GetQueueUrl",
        "autoscaling:DescribeAutoScalingGroups",
        "autoscaling:DescribeAutoScalingInstances",
        "autoscaling:DescribeScalingActivities",
        "autoscaling:DescribeNotificationConfigurations"
      ],
      "Resource": [
        "*"
      ]
    }
  ]
}
EOF
}
