/*
 * Defines variables globally for use in the included .tf resources.
 *
 * Note: There is a "staging" and "production" version of this file.
 *       If you define a new variable, you will most likely define it in both files.
 */

variable "region" {
  type    = "string"
  default = "us-west-2"
}

variable "environment" {
  type    = "string"
  default = "prod"
}

variable "sandstorm_role_arn" {
  type    = "string"
  default = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/history-prod"
}

variable "sandstorm_s3_path" {
  type    = "string"
  default = "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"
}

locals {
  aws_account_id  = "958416494912"
  environment     = "${var.environment}"
  domain_name     = "history.internal.justin.tv"
  api_domain_name = "history-api.internal.justin.tv"

  twitch_subnet = [
    "subnet-baaea6cc",
    "subnet-7b99681c",
    "subnet-83ef97db",
  ]

  security_group = [
    "sg-815057f8",
  ]

  vpc_id = "vpc-c24691a5"
}
