module "history-service-v3" {
  source         = "../modules/history-service-v2"
  environment    = "${local.environment}"
  aws_account_id = "${local.aws_account_id}"

  resource_prefix = "history-v3"

  es_dedicated_master_enabled = false
  es_instance_type            = "t2.medium.elasticsearch"
  es_instance_count           = 3
  es_master_instance_type     = "t2.medium.elasticsearch"
  es_master_instance_count    = 3
  es_volume_size              = 10
  es_zone_awareness_enabled   = false

  ingest_allowed_arns = []

  read_allowed_arns = []

  table_history_write_min_capacity = 10
  table_history_write_max_capacity = 1024

  twitch_subnet  = "${local.twitch_subnet}"
  security_group = "${local.security_group}"

  stream_batch_size  = 1000
  stream_shard_count = 20
}

module "history-service-v3-ecs" {
  source          = "../modules/history-service-ecs"
  environment     = "${local.environment}"
  resource_prefix = "history-service-v3"
}

module "history-service-v3-gdpr" {
  source = "../modules/history-service-gdpr"

  environment     = "${var.environment}"
  region          = "${var.region}"
  resource_prefix = "history-service-v3"

  elasticsearch_domain_arn = "${module.history-service-v3.elasticsearch_domain_arn}"

  user_audits_table_arn = "${module.history-service-v3.audits_table_arn}"

  twitch_subnets                 = "${local.twitch_subnet}"
  security_group                 = "${local.security_group}"
  user_service_hard_delete_topic = "arn:aws:sns:us-west-2:465369119046:notification-user-destroyed"
  gdpr_service_allowed_arn       = []
}

module "history-service-v3-deployment" {
  source          = "../modules/history-service-deployment"
  environment     = "${local.environment}"
  resource_prefix = "history-service-v3"

  allowed_deployment_arns = [
    "arn:aws:iam::613021019375:user/jenkins",
  ]

  ecs_delete_user_task_role_arn          = "${module.history-service-v3-gdpr.ecs_delete_user_task_role_arn}"
  ecs_delete_user_exec_role_arn          = "${module.history-service-v3-gdpr.ecs_delete_user_exec_role_arn}"
  ecs_generate_user_report_task_role_arn = "${module.history-service-v3-gdpr.ecs_generate_user_report_task_role_arn}"
  ecs_generate_user_report_exec_role_arn = "${module.history-service-v3-gdpr.ecs_generate_user_report_exec_role_arn}"

  deployable_lambda_arns = [
    "${module.history-service-v3.lambda_stream_ingest_arn}",
    "${module.history-service-v3-gdpr.lambda_delete_user_arn}",
    "${module.history-service-v3-gdpr.lambda_generate_user_report_arn}",
    "${module.history-service-v3-gdpr.lambda_hard_delete_event_handler_arn}",
  ]
}
