data "aws_iam_user" "jenkins" {
  user_name = "history-admin-${var.environment}-jenkins"
}

resource "aws_iam_user_policy" "jenkins-sts" {
  user   = "${data.aws_iam_user.jenkins.user_name}"
  policy = "${data.aws_iam_policy_document.jenkins-sts-rp.json}"
}

data "aws_iam_policy_document" "jenkins-sts-rp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "arn:aws:iam::180116294062:role/malachai/*",
    ]

    effect = "Allow"
  }
}
