/*
 * Defines variables globally for use in the included .tf resources.
 *
 * Note: There is a "staging" and "production" version of this file.
 *       If you define a new variable, you will most likely define it in both files.
 */

variable "region" {
  type    = "string"
  default = "us-west-2"
}

variable "environment" {
  type    = "string"
  default = "staging"
}

variable "sandstorm_role_arn" {
  type    = "string"
  default = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/history-staging"
}

variable "sandstorm_s3_path" {
  type    = "string"
  default = "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"
}

locals {
  environment    = "${var.environment}"
  aws_account_id = "005087123760"
  prefix         = "history-${var.environment}"

  domain_name     = "history-staging.internal.justin.tv"
  api_domain_name = "history-api-staging.internal.justin.tv"

  twitch_subnet = [
    "subnet-ed93628a",
    "subnet-24eb937c",
    "subnet-39a9a14f",
  ]

  security_group = [
    "sg-564f482f",
  ]

  vpc_id = "vpc-635c8b04"
}
