// General handy functions for printing output

package utils

import (
	"encoding/json"
	"fmt"
	"log"
	"math"
	"time"

	"code.justin.tv/foundation/history-service/configuration"
)

const (
	maxSleepDuration = 60 // seconds
)

// Only print debug output in development environment
func debug() bool {
	env, err := configuration.Environment()
	if err != nil {
		log.Fatal(err)
	}
	return env == "development"
}

// PrettyPrint print JSON
func PrettyPrint(prefix string, x interface{}) {
	if !debug() {
		return
	}

	b, err := json.MarshalIndent(x, "", "  ")
	if err != nil {
		fmt.Println("error:", err)
	}

	Print(prefix, string(b))
}

// Print the input if debug mode on
func Print(x ...interface{}) {
	if !debug() {
		return
	}

	fmt.Println(x...)
}

// BackOff ...
func BackOff(try int) {
	sleepDuration := math.Exp2(float64(try))

	if sleepDuration > maxSleepDuration {
		sleepDuration = maxSleepDuration
	}

	time.Sleep(time.Second * time.Duration(sleepDuration))
}
