variable "vpc_id" {}
variable "vpc_stack_name" {}

data "aws_vpc" "main" {
  id = "${var.vpc_id}"
}

data "aws_subnet" "private-1" {
  vpc_id = "${var.vpc_id}"

  filter {
    name   = "tag:Name"
    values = ["Private - A"]
  }
}

data "aws_route_table" "private-1" {
  subnet_id = "${data.aws_subnet.private-1.id}"
}

data "aws_subnet" "private-2" {
  vpc_id = "${var.vpc_id}"

  filter {
    name   = "tag:Name"
    values = ["Private - B"]
  }
}

data "aws_route_table" "private-2" {
  subnet_id = "${data.aws_subnet.private-2.id}"
}

data "aws_subnet" "private-3" {
  vpc_id = "${var.vpc_id}"

  filter {
    name   = "tag:Name"
    values = ["Private - C"]
  }
}

data "aws_route_table" "private-3" {
  subnet_id = "${data.aws_subnet.private-3.id}"
}

data "aws_subnet" "public-1" {
  vpc_id = "${var.vpc_id}"

  filter {
    name   = "tag:Name"
    values = ["Public - A"]
  }
}

data "aws_subnet" "public-2" {
  vpc_id = "${var.vpc_id}"

  filter {
    name   = "tag:Name"
    values = ["Public - B"]
  }
}

data "aws_subnet" "public-3" {
  vpc_id = "${var.vpc_id}"

  filter {
    name   = "tag:Name"
    values = ["Public - C"]
  }
}

resource "aws_security_group" "aws-endpoint" {
  name        = "VPCStack-AWSEndpointAccessSecurityGroup"
  description = "Allow traffic to AWS Service Endpoints."
  vpc_id      = "${var.vpc_id}"

  ingress {
    from_port = 0
    to_port   = 0
    protocol  = "-1"
    self      = "true"
  }

  egress {
    description = "Suppress the default security group policy in case no other Egress is needed."
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["127.0.0.1/32"]
  }

  egress {
    from_port = 0
    to_port   = 0
    protocol  = "-1"
    self      = "true"
  }

  egress {
    description = "Allow DNS outbound connections to the internet."
    protocol    = "17"
    from_port   = 53
    to_port     = 53
    cidr_blocks = ["0.0.0.0/0"]
  }

  egress {
    description = "Allow HTTPS outbound connections to the internet."
    protocol    = "6"
    from_port   = 443
    to_port     = 443
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name = "VPCStack-AWSEndpointAccessSecurityGroup"
  }
}

resource "aws_cloudformation_stack" "main" {
  name = "${var.vpc_stack_name}"

  template_body = <<EOF
{
  "Outputs" : {
    "AWSEndpointAccessSecurityGroup" : {
      "Export": {"Name": "AWSEndpointAccessSecurityGroup"},
      "Value": "${aws_security_group.aws-endpoint.id}"
    },
    "PrivateRouteTable1" : {
      "Export": {"Name": "PrivateRouteTable1"},
      "Value": "${data.aws_route_table.private-1.route_table_id}"
    },
    "PrivateRouteTable2" : {
      "Export": {"Name": "PrivateRouteTable2"},
      "Value": "${data.aws_route_table.private-2.route_table_id}"
    },
    "PrivateRouteTable3" : {
      "Export": {"Name": "PrivateRouteTable3"},
      "Value": "${data.aws_route_table.private-3.route_table_id}"
    },
    "PrivateSubnet01" : {
      "Export": {"Name": "PrivateSubnet01"},
      "Value": "${data.aws_subnet.private-1.id}"
    },
    "PrivateSubnet01Block" : {
      "Export": {"Name": "PrivateSubnet01Block"},
      "Value": "${data.aws_subnet.private-1.cidr_block}"
    },
    "PrivateSubnet02" : {
      "Export": {"Name": "PrivateSubnet02"},
      "Value": "${data.aws_subnet.private-2.id}"
    },
    "PrivateSubnet02Block" : {
      "Export": {"Name": "PrivateSubnet02Block"},
      "Value": "${data.aws_subnet.private-2.cidr_block}"
    },
    "PrivateSubnet03" : {
      "Export": {"Name": "PrivateSubnet03"},
      "Value": "${data.aws_subnet.private-3.id}"
    },
    "PrivateSubnet03Block" : {
      "Export": {"Name": "PrivateSubnet03Block"},
      "Value": "${data.aws_subnet.private-3.cidr_block}"
    },
    "PublicSubnet01" : {
      "Export": {"Name": "PublicSubnet01"},
      "Value": "${data.aws_subnet.public-1.id}"
    },
    "PublicSubnet01Block" : {
      "Export": {"Name": "PublicSubnet01Block"},
      "Value": "${data.aws_subnet.public-1.cidr_block}"
    },
    "PublicSubnet02" : {
      "Export": {"Name": "PublicSubnet02"},
      "Value": "${data.aws_subnet.public-2.id}"
    },
    "PublicSubnet02Block" : {
      "Export": {"Name": "PublicSubnet02Block"},
      "Value": "${data.aws_subnet.public-2.cidr_block}"
    },
    "PublicSubnet03" : {
      "Export": {"Name": "PublicSubnet03"},
      "Value": "${data.aws_subnet.public-3.id}"
    },
    "PublicSubnet03Block" : {
      "Export": {"Name": "PublicSubnet03Block"},
      "Value": "${data.aws_subnet.public-3.cidr_block}"
    },
    "VPC" : {
      "Export": {"Name": "VPC"},
      "Value": "${data.aws_vpc.main.id}"
    },
    "VPCCidrBlock" : {
      "Export": {"Name": "VPCCidrBlock"},
      "Value": "${data.aws_vpc.main.cidr_block}"
    }
  },
  "Resources": {
    "WaitConditionHandle": {
      "Type" : "AWS::CloudFormation::WaitConditionHandle",
      "Properties" : {}
    }
  }
}
EOF
}
