# General:

This repo contains the worker code for the [History service](https://git-aws.internal.justin.tv/foundation/history-service), which reads audits from SQS, and writes them to DyamoDB and ElasticSearch.

**Staging:** [http://history.staging.us-west2.twitch.tv](http://history.staging.us-west2.twitch.tv)

**Production:** [http://history.prod.us-west2.twitch.tv](http://history.prod.us-west2.twitch.tv)

# Development

    go get github.com/pilu/fresh

and then:

    make dev

This will start the worker locally using `fresh` (which also watches and restarts it on any code changes).

To install dependencies for scripts in the `/scripts` directory, first run `./scripts/install_dependencies`.

Be sure to follow [Go style guide and best practices](https://git-aws.internal.justin.tv/twitch/docs/blob/master/style/go.md).

### Testing
There is currently no test suite for the worker, but there are steps you can take to ensure the changes you make work. First, start the worker locally (follow the instructions above). Next, login to the `twitch-history-dev` AWS account from the [AWS console](console.aws.amazon.com). Navigate to the SQS service, where you should find a `history-dev` queue. Right click the queue, and select "Send a Message". Here, you'll be able to submit an audit that will be read by the history worker you have running locally. An example audit you can manually send:

    {
      "uuid": "a8141a00-8d93-0134-deb5-745c89aa6825",
      "action": "update",
      "user_type": "twitch_user",
      "user_id": "1234",
      "resource_type": "twitch_user",
      "resource_id": "1234",
      "expiry": 8640000,
      "changes": [
        {
          "attribute": "login",
          "old_value": "old_login",
          "new_value": "new_login"
        }
      ]
    }
