// Settings file to hold hardcoded configurations or extract from ENV

package configuration

import (
	"log"
	"os"

	"github.com/cactus/go-statsd-client/statsd"

	"code.justin.tv/common/config"
)

var (
	initialized = false
)

// Initialize the configurations with values from settings & ENV
func init() {
	if initialized {
		return
	}

	config.Register(GetConfig())

	err := config.Parse()
	if err != nil {
		log.Fatal(err)
	}

	initialized = true
}

func StatsdClient() statsd.Statter {
	return config.Statsd()
}

func Resolve(field string) string {
	return config.Resolve(field)
}

// Extract ENVIRONMENT variable or default to development
func Environment() string {
	environment := os.Getenv("ENVIRONMENT")

	if environment == "" {
		environment = "development"
	}

	return environment
}

// Get hardcoded config based on the environment
func GetConfig() map[string]string {
	environment := Environment()

	environmentConfigurations := map[string]map[string]string{
		"development": Development,
		"staging":     Staging,
		"prod":        Production,
	}

	configurations, ok := environmentConfigurations[environment]

	if !ok {
		log.Fatal("Environment: ", environment, " is not supported")
	}

	return configurations
}
