// Shared code for AWS services

package custom_aws

import (
	"net"
	"net/http"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"

	"code.justin.tv/foundation/history-worker/configuration"
)

// Custom http client to be used for AWS services
func httpClient() *http.Client {
	dialer := &net.Dialer{
		Timeout:   5 * time.Second,
		KeepAlive: 30 * time.Second,
	}

	transport := &http.Transport{
		DialContext:         dialer.DialContext,
		MaxIdleConnsPerHost: 5000,
	}

	return &http.Client{
		Transport: transport,
	}
}

// Uses the custom http client and returns an AWS session
func Session() *session.Session {
	config := &aws.Config{
		Region:                        aws.String(configuration.Resolve("awsRegion")),
		HTTPClient:                    httpClient(),
		CredentialsChainVerboseErrors: aws.Bool(true),
	}

	return session.New(config)
}
