// Wrapper package to report stats to statsd

package report

import (
	"time"

	"code.justin.tv/foundation/history-worker/configuration"
)

const (
	STATSD_SAMPLE_RATE = 1.0
)

// Report Performance metric to statsd
func StatsdPerformance(metric_name string, duration time.Duration) {
	err := configuration.StatsdClient().TimingDuration(metric_name, duration, STATSD_SAMPLE_RATE)

	if err != nil {
		RollbarError(err)
	}
}

// Report Throughput metric to statsd
func StatsdThroughput(metric_name string) {
	err := configuration.StatsdClient().Inc(metric_name, 1, STATSD_SAMPLE_RATE)

	if err != nil {
		RollbarError(err)
	}
}

// Report Gauge metric to statsd
func StatsdGauge(metric_name string, value int64) {
	err := configuration.StatsdClient().Gauge(metric_name, value, STATSD_SAMPLE_RATE)

	if err != nil {
		RollbarError(err)
	}
}
