resource "aws_cloudwatch_metric_alarm" "queue-age" {
  alarm_name          = "${local.resource_prefix}-queue-age"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "ApproximateAgeOfOldestMessage"
  namespace           = "AWS/SQS"
  period              = "300"
  statistic           = "Average"
  threshold           = "30"
  alarm_description   = "history-worker queue is backed up."

  dimensions {
    QueueName = "${var.history_worker_queue_name}"
  }

  ok_actions = [
    "${local.alarm_sns_topic}",
  ]

  alarm_actions = [
    "${local.alarm_sns_topic}",
  ]
}

resource "aws_cloudwatch_metric_alarm" "worker-env-health" {
  alarm_name          = "${local.resource_prefix}-worker-env-health"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods  = "1"
  metric_name         = "EnvironmentHealth"
  namespace           = "AWS/ElasticBeanstalk"
  period              = "300"
  statistic           = "Maximum"
  threshold           = "1"
  alarm_description   = "history-worker beanstalk environment is WARNING."

  dimensions {
    EnvironmentName = "${var.history_worker_beanstalk_environment_name}"
  }

  ok_actions = [
    "${local.alarm_sns_topic}",
  ]

  alarm_actions = [
    "${local.alarm_sns_topic}",
  ]
}
