variable "retention" {
  type    = "string"
  default = "86400"
}

resource "aws_sqs_queue" "history" {
  name                       = "history-${var.environment}"
  delay_seconds              = 0
  max_message_size           = 8192
  message_retention_seconds  = "${var.retention}"
  receive_wait_time_seconds  = 0
  visibility_timeout_seconds = 30
}

// Grant the [staging/prod]-foundation-history-worker role ability to do all SQS queue actions.
// Grant the [staging/prod]-foundation-history-service role ability to do all SQS queue actions.
//
resource "aws_sqs_queue_policy" "history_queue_policy" {
  queue_url = "${aws_sqs_queue.history.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "${aws_sqs_queue.history.arn}/SQSDefaultPolicy",
  "Statement": [
    {
      "Sid": "",
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::958416494912:role/${var.environment}-foundation-history-worker"
      },
      "Action": "SQS:*",
      "Resource": "${aws_sqs_queue.history.arn}"
    },
    {
      "Sid": "",
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::958416494912:role/history-service-${var.environment}"
      },
      "Action": "SQS:*",
      "Resource": "${aws_sqs_queue.history.arn}"
    }
  ]
}
EOF
}
