resource "aws_dynamodb_table" "history" {
  name           = "history-prod"
  read_capacity  = 100
  write_capacity = 100
  hash_key       = "uuid"

  attribute {
    name = "uuid"
    type = "S"
  }

  ttl {
    attribute_name = "expired_at"
    enabled        = true
  }

  lifecycle {
    ignore_changes = [
      "read_capacity",
      "write_capacity",
    ]
  }
}

module "history_autoscaling" {
  source                                  = "../modules/dynamodb_autoscaling"
  table_name                              = "${aws_dynamodb_table.history.name}"
  table_read_min_capacity                 = 100
  table_read_max_capacity                 = 1000
  table_read_target_capacity_utilization  = 70
  table_write_min_capacity                = 100
  table_write_max_capacity                = 1000
  table_write_target_capacity_utilization = 70
}
