// General handy functions for printing output

package utils

import (
	"code.justin.tv/foundation/history-worker/configuration"
	"encoding/json"
	"fmt"
	"math"
	"time"
)

const (
	maxSleepDuration = 60 // seconds
)

// Only print debug output in development environment
func debug() bool {
	return configuration.Environment() == "development"
}

// Pretty print JSON
func PrettyPrint(prefix string, x interface{}) {
	if !debug() {
		return
	}

	b, err := json.MarshalIndent(x, "", "  ")
	if err != nil {
		fmt.Println("error:", err)
	}

	Print(prefix, string(b))
}

// Print the input if debug mode on
func Print(x ...interface{}) {
	if !debug() {
		return
	}

	fmt.Println(x...)
}

func BackOff(try int) {
	sleepDuration := math.Exp2(float64(try))

	if sleepDuration > maxSleepDuration {
		sleepDuration = maxSleepDuration
	}

	time.Sleep(time.Second * time.Duration(sleepDuration))
}
