package mocks

import aws "github.com/aws/aws-sdk-go/aws"
import kinesis "github.com/aws/aws-sdk-go/service/kinesis"

import mock "github.com/stretchr/testify/mock"
import request "github.com/aws/aws-sdk-go/aws/request"

// KinesisAPI is an autogenerated mock type for the KinesisAPI type
type KinesisAPI struct {
	mock.Mock
}

// AddTagsToStream provides a mock function with given fields: _a0
func (_m *KinesisAPI) AddTagsToStream(_a0 *kinesis.AddTagsToStreamInput) (*kinesis.AddTagsToStreamOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.AddTagsToStreamOutput
	if rf, ok := ret.Get(0).(func(*kinesis.AddTagsToStreamInput) *kinesis.AddTagsToStreamOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.AddTagsToStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.AddTagsToStreamInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AddTagsToStreamRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) AddTagsToStreamRequest(_a0 *kinesis.AddTagsToStreamInput) (*request.Request, *kinesis.AddTagsToStreamOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.AddTagsToStreamInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.AddTagsToStreamOutput
	if rf, ok := ret.Get(1).(func(*kinesis.AddTagsToStreamInput) *kinesis.AddTagsToStreamOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.AddTagsToStreamOutput)
		}
	}

	return r0, r1
}

// AddTagsToStreamWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) AddTagsToStreamWithContext(_a0 aws.Context, _a1 *kinesis.AddTagsToStreamInput, _a2 ...request.Option) (*kinesis.AddTagsToStreamOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.AddTagsToStreamOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.AddTagsToStreamInput, ...request.Option) *kinesis.AddTagsToStreamOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.AddTagsToStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.AddTagsToStreamInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateStream provides a mock function with given fields: _a0
func (_m *KinesisAPI) CreateStream(_a0 *kinesis.CreateStreamInput) (*kinesis.CreateStreamOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.CreateStreamOutput
	if rf, ok := ret.Get(0).(func(*kinesis.CreateStreamInput) *kinesis.CreateStreamOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.CreateStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.CreateStreamInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateStreamRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) CreateStreamRequest(_a0 *kinesis.CreateStreamInput) (*request.Request, *kinesis.CreateStreamOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.CreateStreamInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.CreateStreamOutput
	if rf, ok := ret.Get(1).(func(*kinesis.CreateStreamInput) *kinesis.CreateStreamOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.CreateStreamOutput)
		}
	}

	return r0, r1
}

// CreateStreamWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) CreateStreamWithContext(_a0 aws.Context, _a1 *kinesis.CreateStreamInput, _a2 ...request.Option) (*kinesis.CreateStreamOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.CreateStreamOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.CreateStreamInput, ...request.Option) *kinesis.CreateStreamOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.CreateStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.CreateStreamInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DecreaseStreamRetentionPeriod provides a mock function with given fields: _a0
func (_m *KinesisAPI) DecreaseStreamRetentionPeriod(_a0 *kinesis.DecreaseStreamRetentionPeriodInput) (*kinesis.DecreaseStreamRetentionPeriodOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.DecreaseStreamRetentionPeriodOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DecreaseStreamRetentionPeriodInput) *kinesis.DecreaseStreamRetentionPeriodOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DecreaseStreamRetentionPeriodOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DecreaseStreamRetentionPeriodInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DecreaseStreamRetentionPeriodRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DecreaseStreamRetentionPeriodRequest(_a0 *kinesis.DecreaseStreamRetentionPeriodInput) (*request.Request, *kinesis.DecreaseStreamRetentionPeriodOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DecreaseStreamRetentionPeriodInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.DecreaseStreamRetentionPeriodOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DecreaseStreamRetentionPeriodInput) *kinesis.DecreaseStreamRetentionPeriodOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.DecreaseStreamRetentionPeriodOutput)
		}
	}

	return r0, r1
}

// DecreaseStreamRetentionPeriodWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DecreaseStreamRetentionPeriodWithContext(_a0 aws.Context, _a1 *kinesis.DecreaseStreamRetentionPeriodInput, _a2 ...request.Option) (*kinesis.DecreaseStreamRetentionPeriodOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.DecreaseStreamRetentionPeriodOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DecreaseStreamRetentionPeriodInput, ...request.Option) *kinesis.DecreaseStreamRetentionPeriodOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DecreaseStreamRetentionPeriodOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DecreaseStreamRetentionPeriodInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteStream provides a mock function with given fields: _a0
func (_m *KinesisAPI) DeleteStream(_a0 *kinesis.DeleteStreamInput) (*kinesis.DeleteStreamOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.DeleteStreamOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DeleteStreamInput) *kinesis.DeleteStreamOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DeleteStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DeleteStreamInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteStreamRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DeleteStreamRequest(_a0 *kinesis.DeleteStreamInput) (*request.Request, *kinesis.DeleteStreamOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DeleteStreamInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.DeleteStreamOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DeleteStreamInput) *kinesis.DeleteStreamOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.DeleteStreamOutput)
		}
	}

	return r0, r1
}

// DeleteStreamWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DeleteStreamWithContext(_a0 aws.Context, _a1 *kinesis.DeleteStreamInput, _a2 ...request.Option) (*kinesis.DeleteStreamOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.DeleteStreamOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DeleteStreamInput, ...request.Option) *kinesis.DeleteStreamOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DeleteStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DeleteStreamInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeregisterStreamConsumer provides a mock function with given fields: _a0
func (_m *KinesisAPI) DeregisterStreamConsumer(_a0 *kinesis.DeregisterStreamConsumerInput) (*kinesis.DeregisterStreamConsumerOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.DeregisterStreamConsumerOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DeregisterStreamConsumerInput) *kinesis.DeregisterStreamConsumerOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DeregisterStreamConsumerOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DeregisterStreamConsumerInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeregisterStreamConsumerRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DeregisterStreamConsumerRequest(_a0 *kinesis.DeregisterStreamConsumerInput) (*request.Request, *kinesis.DeregisterStreamConsumerOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DeregisterStreamConsumerInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.DeregisterStreamConsumerOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DeregisterStreamConsumerInput) *kinesis.DeregisterStreamConsumerOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.DeregisterStreamConsumerOutput)
		}
	}

	return r0, r1
}

// DeregisterStreamConsumerWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DeregisterStreamConsumerWithContext(_a0 aws.Context, _a1 *kinesis.DeregisterStreamConsumerInput, _a2 ...request.Option) (*kinesis.DeregisterStreamConsumerOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.DeregisterStreamConsumerOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DeregisterStreamConsumerInput, ...request.Option) *kinesis.DeregisterStreamConsumerOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DeregisterStreamConsumerOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DeregisterStreamConsumerInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeLimits provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeLimits(_a0 *kinesis.DescribeLimitsInput) (*kinesis.DescribeLimitsOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.DescribeLimitsOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeLimitsInput) *kinesis.DescribeLimitsOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeLimitsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeLimitsInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeLimitsRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeLimitsRequest(_a0 *kinesis.DescribeLimitsInput) (*request.Request, *kinesis.DescribeLimitsOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeLimitsInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.DescribeLimitsOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeLimitsInput) *kinesis.DescribeLimitsOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.DescribeLimitsOutput)
		}
	}

	return r0, r1
}

// DescribeLimitsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DescribeLimitsWithContext(_a0 aws.Context, _a1 *kinesis.DescribeLimitsInput, _a2 ...request.Option) (*kinesis.DescribeLimitsOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.DescribeLimitsOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DescribeLimitsInput, ...request.Option) *kinesis.DescribeLimitsOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeLimitsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DescribeLimitsInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeStream provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeStream(_a0 *kinesis.DescribeStreamInput) (*kinesis.DescribeStreamOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.DescribeStreamOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamInput) *kinesis.DescribeStreamOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeStreamInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeStreamConsumer provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeStreamConsumer(_a0 *kinesis.DescribeStreamConsumerInput) (*kinesis.DescribeStreamConsumerOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.DescribeStreamConsumerOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamConsumerInput) *kinesis.DescribeStreamConsumerOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeStreamConsumerOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeStreamConsumerInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeStreamConsumerRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeStreamConsumerRequest(_a0 *kinesis.DescribeStreamConsumerInput) (*request.Request, *kinesis.DescribeStreamConsumerOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamConsumerInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.DescribeStreamConsumerOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeStreamConsumerInput) *kinesis.DescribeStreamConsumerOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.DescribeStreamConsumerOutput)
		}
	}

	return r0, r1
}

// DescribeStreamConsumerWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DescribeStreamConsumerWithContext(_a0 aws.Context, _a1 *kinesis.DescribeStreamConsumerInput, _a2 ...request.Option) (*kinesis.DescribeStreamConsumerOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.DescribeStreamConsumerOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DescribeStreamConsumerInput, ...request.Option) *kinesis.DescribeStreamConsumerOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeStreamConsumerOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DescribeStreamConsumerInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeStreamPages provides a mock function with given fields: _a0, _a1
func (_m *KinesisAPI) DescribeStreamPages(_a0 *kinesis.DescribeStreamInput, _a1 func(*kinesis.DescribeStreamOutput, bool) bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamInput, func(*kinesis.DescribeStreamOutput, bool) bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DescribeStreamPagesWithContext provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *KinesisAPI) DescribeStreamPagesWithContext(_a0 aws.Context, _a1 *kinesis.DescribeStreamInput, _a2 func(*kinesis.DescribeStreamOutput, bool) bool, _a3 ...request.Option) error {
	_va := make([]interface{}, len(_a3))
	for _i := range _a3 {
		_va[_i] = _a3[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1, _a2)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DescribeStreamInput, func(*kinesis.DescribeStreamOutput, bool) bool, ...request.Option) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DescribeStreamRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeStreamRequest(_a0 *kinesis.DescribeStreamInput) (*request.Request, *kinesis.DescribeStreamOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.DescribeStreamOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeStreamInput) *kinesis.DescribeStreamOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.DescribeStreamOutput)
		}
	}

	return r0, r1
}

// DescribeStreamSummary provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeStreamSummary(_a0 *kinesis.DescribeStreamSummaryInput) (*kinesis.DescribeStreamSummaryOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.DescribeStreamSummaryOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamSummaryInput) *kinesis.DescribeStreamSummaryOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeStreamSummaryOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeStreamSummaryInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeStreamSummaryRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DescribeStreamSummaryRequest(_a0 *kinesis.DescribeStreamSummaryInput) (*request.Request, *kinesis.DescribeStreamSummaryOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamSummaryInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.DescribeStreamSummaryOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DescribeStreamSummaryInput) *kinesis.DescribeStreamSummaryOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.DescribeStreamSummaryOutput)
		}
	}

	return r0, r1
}

// DescribeStreamSummaryWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DescribeStreamSummaryWithContext(_a0 aws.Context, _a1 *kinesis.DescribeStreamSummaryInput, _a2 ...request.Option) (*kinesis.DescribeStreamSummaryOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.DescribeStreamSummaryOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DescribeStreamSummaryInput, ...request.Option) *kinesis.DescribeStreamSummaryOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeStreamSummaryOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DescribeStreamSummaryInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeStreamWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DescribeStreamWithContext(_a0 aws.Context, _a1 *kinesis.DescribeStreamInput, _a2 ...request.Option) (*kinesis.DescribeStreamOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.DescribeStreamOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DescribeStreamInput, ...request.Option) *kinesis.DescribeStreamOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.DescribeStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DescribeStreamInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DisableEnhancedMonitoring provides a mock function with given fields: _a0
func (_m *KinesisAPI) DisableEnhancedMonitoring(_a0 *kinesis.DisableEnhancedMonitoringInput) (*kinesis.EnhancedMonitoringOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.EnhancedMonitoringOutput
	if rf, ok := ret.Get(0).(func(*kinesis.DisableEnhancedMonitoringInput) *kinesis.EnhancedMonitoringOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.EnhancedMonitoringOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.DisableEnhancedMonitoringInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DisableEnhancedMonitoringRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) DisableEnhancedMonitoringRequest(_a0 *kinesis.DisableEnhancedMonitoringInput) (*request.Request, *kinesis.EnhancedMonitoringOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.DisableEnhancedMonitoringInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.EnhancedMonitoringOutput
	if rf, ok := ret.Get(1).(func(*kinesis.DisableEnhancedMonitoringInput) *kinesis.EnhancedMonitoringOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.EnhancedMonitoringOutput)
		}
	}

	return r0, r1
}

// DisableEnhancedMonitoringWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) DisableEnhancedMonitoringWithContext(_a0 aws.Context, _a1 *kinesis.DisableEnhancedMonitoringInput, _a2 ...request.Option) (*kinesis.EnhancedMonitoringOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.EnhancedMonitoringOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DisableEnhancedMonitoringInput, ...request.Option) *kinesis.EnhancedMonitoringOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.EnhancedMonitoringOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.DisableEnhancedMonitoringInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// EnableEnhancedMonitoring provides a mock function with given fields: _a0
func (_m *KinesisAPI) EnableEnhancedMonitoring(_a0 *kinesis.EnableEnhancedMonitoringInput) (*kinesis.EnhancedMonitoringOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.EnhancedMonitoringOutput
	if rf, ok := ret.Get(0).(func(*kinesis.EnableEnhancedMonitoringInput) *kinesis.EnhancedMonitoringOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.EnhancedMonitoringOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.EnableEnhancedMonitoringInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// EnableEnhancedMonitoringRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) EnableEnhancedMonitoringRequest(_a0 *kinesis.EnableEnhancedMonitoringInput) (*request.Request, *kinesis.EnhancedMonitoringOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.EnableEnhancedMonitoringInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.EnhancedMonitoringOutput
	if rf, ok := ret.Get(1).(func(*kinesis.EnableEnhancedMonitoringInput) *kinesis.EnhancedMonitoringOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.EnhancedMonitoringOutput)
		}
	}

	return r0, r1
}

// EnableEnhancedMonitoringWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) EnableEnhancedMonitoringWithContext(_a0 aws.Context, _a1 *kinesis.EnableEnhancedMonitoringInput, _a2 ...request.Option) (*kinesis.EnhancedMonitoringOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.EnhancedMonitoringOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.EnableEnhancedMonitoringInput, ...request.Option) *kinesis.EnhancedMonitoringOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.EnhancedMonitoringOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.EnableEnhancedMonitoringInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRecords provides a mock function with given fields: _a0
func (_m *KinesisAPI) GetRecords(_a0 *kinesis.GetRecordsInput) (*kinesis.GetRecordsOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.GetRecordsOutput
	if rf, ok := ret.Get(0).(func(*kinesis.GetRecordsInput) *kinesis.GetRecordsOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.GetRecordsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.GetRecordsInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRecordsRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) GetRecordsRequest(_a0 *kinesis.GetRecordsInput) (*request.Request, *kinesis.GetRecordsOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.GetRecordsInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.GetRecordsOutput
	if rf, ok := ret.Get(1).(func(*kinesis.GetRecordsInput) *kinesis.GetRecordsOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.GetRecordsOutput)
		}
	}

	return r0, r1
}

// GetRecordsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) GetRecordsWithContext(_a0 aws.Context, _a1 *kinesis.GetRecordsInput, _a2 ...request.Option) (*kinesis.GetRecordsOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.GetRecordsOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.GetRecordsInput, ...request.Option) *kinesis.GetRecordsOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.GetRecordsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.GetRecordsInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetShardIterator provides a mock function with given fields: _a0
func (_m *KinesisAPI) GetShardIterator(_a0 *kinesis.GetShardIteratorInput) (*kinesis.GetShardIteratorOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.GetShardIteratorOutput
	if rf, ok := ret.Get(0).(func(*kinesis.GetShardIteratorInput) *kinesis.GetShardIteratorOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.GetShardIteratorOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.GetShardIteratorInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetShardIteratorRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) GetShardIteratorRequest(_a0 *kinesis.GetShardIteratorInput) (*request.Request, *kinesis.GetShardIteratorOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.GetShardIteratorInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.GetShardIteratorOutput
	if rf, ok := ret.Get(1).(func(*kinesis.GetShardIteratorInput) *kinesis.GetShardIteratorOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.GetShardIteratorOutput)
		}
	}

	return r0, r1
}

// GetShardIteratorWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) GetShardIteratorWithContext(_a0 aws.Context, _a1 *kinesis.GetShardIteratorInput, _a2 ...request.Option) (*kinesis.GetShardIteratorOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.GetShardIteratorOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.GetShardIteratorInput, ...request.Option) *kinesis.GetShardIteratorOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.GetShardIteratorOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.GetShardIteratorInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IncreaseStreamRetentionPeriod provides a mock function with given fields: _a0
func (_m *KinesisAPI) IncreaseStreamRetentionPeriod(_a0 *kinesis.IncreaseStreamRetentionPeriodInput) (*kinesis.IncreaseStreamRetentionPeriodOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.IncreaseStreamRetentionPeriodOutput
	if rf, ok := ret.Get(0).(func(*kinesis.IncreaseStreamRetentionPeriodInput) *kinesis.IncreaseStreamRetentionPeriodOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.IncreaseStreamRetentionPeriodOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.IncreaseStreamRetentionPeriodInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IncreaseStreamRetentionPeriodRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) IncreaseStreamRetentionPeriodRequest(_a0 *kinesis.IncreaseStreamRetentionPeriodInput) (*request.Request, *kinesis.IncreaseStreamRetentionPeriodOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.IncreaseStreamRetentionPeriodInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.IncreaseStreamRetentionPeriodOutput
	if rf, ok := ret.Get(1).(func(*kinesis.IncreaseStreamRetentionPeriodInput) *kinesis.IncreaseStreamRetentionPeriodOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.IncreaseStreamRetentionPeriodOutput)
		}
	}

	return r0, r1
}

// IncreaseStreamRetentionPeriodWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) IncreaseStreamRetentionPeriodWithContext(_a0 aws.Context, _a1 *kinesis.IncreaseStreamRetentionPeriodInput, _a2 ...request.Option) (*kinesis.IncreaseStreamRetentionPeriodOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.IncreaseStreamRetentionPeriodOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.IncreaseStreamRetentionPeriodInput, ...request.Option) *kinesis.IncreaseStreamRetentionPeriodOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.IncreaseStreamRetentionPeriodOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.IncreaseStreamRetentionPeriodInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListShards provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListShards(_a0 *kinesis.ListShardsInput) (*kinesis.ListShardsOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.ListShardsOutput
	if rf, ok := ret.Get(0).(func(*kinesis.ListShardsInput) *kinesis.ListShardsOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListShardsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.ListShardsInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListShardsRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListShardsRequest(_a0 *kinesis.ListShardsInput) (*request.Request, *kinesis.ListShardsOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.ListShardsInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.ListShardsOutput
	if rf, ok := ret.Get(1).(func(*kinesis.ListShardsInput) *kinesis.ListShardsOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.ListShardsOutput)
		}
	}

	return r0, r1
}

// ListShardsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) ListShardsWithContext(_a0 aws.Context, _a1 *kinesis.ListShardsInput, _a2 ...request.Option) (*kinesis.ListShardsOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.ListShardsOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.ListShardsInput, ...request.Option) *kinesis.ListShardsOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListShardsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.ListShardsInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListStreamConsumers provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListStreamConsumers(_a0 *kinesis.ListStreamConsumersInput) (*kinesis.ListStreamConsumersOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.ListStreamConsumersOutput
	if rf, ok := ret.Get(0).(func(*kinesis.ListStreamConsumersInput) *kinesis.ListStreamConsumersOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListStreamConsumersOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.ListStreamConsumersInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListStreamConsumersPages provides a mock function with given fields: _a0, _a1
func (_m *KinesisAPI) ListStreamConsumersPages(_a0 *kinesis.ListStreamConsumersInput, _a1 func(*kinesis.ListStreamConsumersOutput, bool) bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*kinesis.ListStreamConsumersInput, func(*kinesis.ListStreamConsumersOutput, bool) bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListStreamConsumersPagesWithContext provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *KinesisAPI) ListStreamConsumersPagesWithContext(_a0 aws.Context, _a1 *kinesis.ListStreamConsumersInput, _a2 func(*kinesis.ListStreamConsumersOutput, bool) bool, _a3 ...request.Option) error {
	_va := make([]interface{}, len(_a3))
	for _i := range _a3 {
		_va[_i] = _a3[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1, _a2)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.ListStreamConsumersInput, func(*kinesis.ListStreamConsumersOutput, bool) bool, ...request.Option) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListStreamConsumersRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListStreamConsumersRequest(_a0 *kinesis.ListStreamConsumersInput) (*request.Request, *kinesis.ListStreamConsumersOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.ListStreamConsumersInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.ListStreamConsumersOutput
	if rf, ok := ret.Get(1).(func(*kinesis.ListStreamConsumersInput) *kinesis.ListStreamConsumersOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.ListStreamConsumersOutput)
		}
	}

	return r0, r1
}

// ListStreamConsumersWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) ListStreamConsumersWithContext(_a0 aws.Context, _a1 *kinesis.ListStreamConsumersInput, _a2 ...request.Option) (*kinesis.ListStreamConsumersOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.ListStreamConsumersOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.ListStreamConsumersInput, ...request.Option) *kinesis.ListStreamConsumersOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListStreamConsumersOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.ListStreamConsumersInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListStreams provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListStreams(_a0 *kinesis.ListStreamsInput) (*kinesis.ListStreamsOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.ListStreamsOutput
	if rf, ok := ret.Get(0).(func(*kinesis.ListStreamsInput) *kinesis.ListStreamsOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListStreamsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.ListStreamsInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListStreamsPages provides a mock function with given fields: _a0, _a1
func (_m *KinesisAPI) ListStreamsPages(_a0 *kinesis.ListStreamsInput, _a1 func(*kinesis.ListStreamsOutput, bool) bool) error {
	ret := _m.Called(_a0, _a1)

	var r0 error
	if rf, ok := ret.Get(0).(func(*kinesis.ListStreamsInput, func(*kinesis.ListStreamsOutput, bool) bool) error); ok {
		r0 = rf(_a0, _a1)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListStreamsPagesWithContext provides a mock function with given fields: _a0, _a1, _a2, _a3
func (_m *KinesisAPI) ListStreamsPagesWithContext(_a0 aws.Context, _a1 *kinesis.ListStreamsInput, _a2 func(*kinesis.ListStreamsOutput, bool) bool, _a3 ...request.Option) error {
	_va := make([]interface{}, len(_a3))
	for _i := range _a3 {
		_va[_i] = _a3[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1, _a2)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.ListStreamsInput, func(*kinesis.ListStreamsOutput, bool) bool, ...request.Option) error); ok {
		r0 = rf(_a0, _a1, _a2, _a3...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ListStreamsRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListStreamsRequest(_a0 *kinesis.ListStreamsInput) (*request.Request, *kinesis.ListStreamsOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.ListStreamsInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.ListStreamsOutput
	if rf, ok := ret.Get(1).(func(*kinesis.ListStreamsInput) *kinesis.ListStreamsOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.ListStreamsOutput)
		}
	}

	return r0, r1
}

// ListStreamsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) ListStreamsWithContext(_a0 aws.Context, _a1 *kinesis.ListStreamsInput, _a2 ...request.Option) (*kinesis.ListStreamsOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.ListStreamsOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.ListStreamsInput, ...request.Option) *kinesis.ListStreamsOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListStreamsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.ListStreamsInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListTagsForStream provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListTagsForStream(_a0 *kinesis.ListTagsForStreamInput) (*kinesis.ListTagsForStreamOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.ListTagsForStreamOutput
	if rf, ok := ret.Get(0).(func(*kinesis.ListTagsForStreamInput) *kinesis.ListTagsForStreamOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListTagsForStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.ListTagsForStreamInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListTagsForStreamRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) ListTagsForStreamRequest(_a0 *kinesis.ListTagsForStreamInput) (*request.Request, *kinesis.ListTagsForStreamOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.ListTagsForStreamInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.ListTagsForStreamOutput
	if rf, ok := ret.Get(1).(func(*kinesis.ListTagsForStreamInput) *kinesis.ListTagsForStreamOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.ListTagsForStreamOutput)
		}
	}

	return r0, r1
}

// ListTagsForStreamWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) ListTagsForStreamWithContext(_a0 aws.Context, _a1 *kinesis.ListTagsForStreamInput, _a2 ...request.Option) (*kinesis.ListTagsForStreamOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.ListTagsForStreamOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.ListTagsForStreamInput, ...request.Option) *kinesis.ListTagsForStreamOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.ListTagsForStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.ListTagsForStreamInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MergeShards provides a mock function with given fields: _a0
func (_m *KinesisAPI) MergeShards(_a0 *kinesis.MergeShardsInput) (*kinesis.MergeShardsOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.MergeShardsOutput
	if rf, ok := ret.Get(0).(func(*kinesis.MergeShardsInput) *kinesis.MergeShardsOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.MergeShardsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.MergeShardsInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// MergeShardsRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) MergeShardsRequest(_a0 *kinesis.MergeShardsInput) (*request.Request, *kinesis.MergeShardsOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.MergeShardsInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.MergeShardsOutput
	if rf, ok := ret.Get(1).(func(*kinesis.MergeShardsInput) *kinesis.MergeShardsOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.MergeShardsOutput)
		}
	}

	return r0, r1
}

// MergeShardsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) MergeShardsWithContext(_a0 aws.Context, _a1 *kinesis.MergeShardsInput, _a2 ...request.Option) (*kinesis.MergeShardsOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.MergeShardsOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.MergeShardsInput, ...request.Option) *kinesis.MergeShardsOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.MergeShardsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.MergeShardsInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PutRecord provides a mock function with given fields: _a0
func (_m *KinesisAPI) PutRecord(_a0 *kinesis.PutRecordInput) (*kinesis.PutRecordOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.PutRecordOutput
	if rf, ok := ret.Get(0).(func(*kinesis.PutRecordInput) *kinesis.PutRecordOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.PutRecordOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.PutRecordInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PutRecordRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) PutRecordRequest(_a0 *kinesis.PutRecordInput) (*request.Request, *kinesis.PutRecordOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.PutRecordInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.PutRecordOutput
	if rf, ok := ret.Get(1).(func(*kinesis.PutRecordInput) *kinesis.PutRecordOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.PutRecordOutput)
		}
	}

	return r0, r1
}

// PutRecordWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) PutRecordWithContext(_a0 aws.Context, _a1 *kinesis.PutRecordInput, _a2 ...request.Option) (*kinesis.PutRecordOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.PutRecordOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.PutRecordInput, ...request.Option) *kinesis.PutRecordOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.PutRecordOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.PutRecordInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PutRecords provides a mock function with given fields: _a0
func (_m *KinesisAPI) PutRecords(_a0 *kinesis.PutRecordsInput) (*kinesis.PutRecordsOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.PutRecordsOutput
	if rf, ok := ret.Get(0).(func(*kinesis.PutRecordsInput) *kinesis.PutRecordsOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.PutRecordsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.PutRecordsInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PutRecordsRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) PutRecordsRequest(_a0 *kinesis.PutRecordsInput) (*request.Request, *kinesis.PutRecordsOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.PutRecordsInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.PutRecordsOutput
	if rf, ok := ret.Get(1).(func(*kinesis.PutRecordsInput) *kinesis.PutRecordsOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.PutRecordsOutput)
		}
	}

	return r0, r1
}

// PutRecordsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) PutRecordsWithContext(_a0 aws.Context, _a1 *kinesis.PutRecordsInput, _a2 ...request.Option) (*kinesis.PutRecordsOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.PutRecordsOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.PutRecordsInput, ...request.Option) *kinesis.PutRecordsOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.PutRecordsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.PutRecordsInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RegisterStreamConsumer provides a mock function with given fields: _a0
func (_m *KinesisAPI) RegisterStreamConsumer(_a0 *kinesis.RegisterStreamConsumerInput) (*kinesis.RegisterStreamConsumerOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.RegisterStreamConsumerOutput
	if rf, ok := ret.Get(0).(func(*kinesis.RegisterStreamConsumerInput) *kinesis.RegisterStreamConsumerOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.RegisterStreamConsumerOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.RegisterStreamConsumerInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RegisterStreamConsumerRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) RegisterStreamConsumerRequest(_a0 *kinesis.RegisterStreamConsumerInput) (*request.Request, *kinesis.RegisterStreamConsumerOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.RegisterStreamConsumerInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.RegisterStreamConsumerOutput
	if rf, ok := ret.Get(1).(func(*kinesis.RegisterStreamConsumerInput) *kinesis.RegisterStreamConsumerOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.RegisterStreamConsumerOutput)
		}
	}

	return r0, r1
}

// RegisterStreamConsumerWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) RegisterStreamConsumerWithContext(_a0 aws.Context, _a1 *kinesis.RegisterStreamConsumerInput, _a2 ...request.Option) (*kinesis.RegisterStreamConsumerOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.RegisterStreamConsumerOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.RegisterStreamConsumerInput, ...request.Option) *kinesis.RegisterStreamConsumerOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.RegisterStreamConsumerOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.RegisterStreamConsumerInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RemoveTagsFromStream provides a mock function with given fields: _a0
func (_m *KinesisAPI) RemoveTagsFromStream(_a0 *kinesis.RemoveTagsFromStreamInput) (*kinesis.RemoveTagsFromStreamOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.RemoveTagsFromStreamOutput
	if rf, ok := ret.Get(0).(func(*kinesis.RemoveTagsFromStreamInput) *kinesis.RemoveTagsFromStreamOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.RemoveTagsFromStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.RemoveTagsFromStreamInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RemoveTagsFromStreamRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) RemoveTagsFromStreamRequest(_a0 *kinesis.RemoveTagsFromStreamInput) (*request.Request, *kinesis.RemoveTagsFromStreamOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.RemoveTagsFromStreamInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.RemoveTagsFromStreamOutput
	if rf, ok := ret.Get(1).(func(*kinesis.RemoveTagsFromStreamInput) *kinesis.RemoveTagsFromStreamOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.RemoveTagsFromStreamOutput)
		}
	}

	return r0, r1
}

// RemoveTagsFromStreamWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) RemoveTagsFromStreamWithContext(_a0 aws.Context, _a1 *kinesis.RemoveTagsFromStreamInput, _a2 ...request.Option) (*kinesis.RemoveTagsFromStreamOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.RemoveTagsFromStreamOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.RemoveTagsFromStreamInput, ...request.Option) *kinesis.RemoveTagsFromStreamOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.RemoveTagsFromStreamOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.RemoveTagsFromStreamInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SplitShard provides a mock function with given fields: _a0
func (_m *KinesisAPI) SplitShard(_a0 *kinesis.SplitShardInput) (*kinesis.SplitShardOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.SplitShardOutput
	if rf, ok := ret.Get(0).(func(*kinesis.SplitShardInput) *kinesis.SplitShardOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.SplitShardOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.SplitShardInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SplitShardRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) SplitShardRequest(_a0 *kinesis.SplitShardInput) (*request.Request, *kinesis.SplitShardOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.SplitShardInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.SplitShardOutput
	if rf, ok := ret.Get(1).(func(*kinesis.SplitShardInput) *kinesis.SplitShardOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.SplitShardOutput)
		}
	}

	return r0, r1
}

// SplitShardWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) SplitShardWithContext(_a0 aws.Context, _a1 *kinesis.SplitShardInput, _a2 ...request.Option) (*kinesis.SplitShardOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.SplitShardOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.SplitShardInput, ...request.Option) *kinesis.SplitShardOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.SplitShardOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.SplitShardInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// StartStreamEncryption provides a mock function with given fields: _a0
func (_m *KinesisAPI) StartStreamEncryption(_a0 *kinesis.StartStreamEncryptionInput) (*kinesis.StartStreamEncryptionOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.StartStreamEncryptionOutput
	if rf, ok := ret.Get(0).(func(*kinesis.StartStreamEncryptionInput) *kinesis.StartStreamEncryptionOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.StartStreamEncryptionOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.StartStreamEncryptionInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// StartStreamEncryptionRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) StartStreamEncryptionRequest(_a0 *kinesis.StartStreamEncryptionInput) (*request.Request, *kinesis.StartStreamEncryptionOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.StartStreamEncryptionInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.StartStreamEncryptionOutput
	if rf, ok := ret.Get(1).(func(*kinesis.StartStreamEncryptionInput) *kinesis.StartStreamEncryptionOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.StartStreamEncryptionOutput)
		}
	}

	return r0, r1
}

// StartStreamEncryptionWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) StartStreamEncryptionWithContext(_a0 aws.Context, _a1 *kinesis.StartStreamEncryptionInput, _a2 ...request.Option) (*kinesis.StartStreamEncryptionOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.StartStreamEncryptionOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.StartStreamEncryptionInput, ...request.Option) *kinesis.StartStreamEncryptionOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.StartStreamEncryptionOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.StartStreamEncryptionInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// StopStreamEncryption provides a mock function with given fields: _a0
func (_m *KinesisAPI) StopStreamEncryption(_a0 *kinesis.StopStreamEncryptionInput) (*kinesis.StopStreamEncryptionOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.StopStreamEncryptionOutput
	if rf, ok := ret.Get(0).(func(*kinesis.StopStreamEncryptionInput) *kinesis.StopStreamEncryptionOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.StopStreamEncryptionOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.StopStreamEncryptionInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// StopStreamEncryptionRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) StopStreamEncryptionRequest(_a0 *kinesis.StopStreamEncryptionInput) (*request.Request, *kinesis.StopStreamEncryptionOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.StopStreamEncryptionInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.StopStreamEncryptionOutput
	if rf, ok := ret.Get(1).(func(*kinesis.StopStreamEncryptionInput) *kinesis.StopStreamEncryptionOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.StopStreamEncryptionOutput)
		}
	}

	return r0, r1
}

// StopStreamEncryptionWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) StopStreamEncryptionWithContext(_a0 aws.Context, _a1 *kinesis.StopStreamEncryptionInput, _a2 ...request.Option) (*kinesis.StopStreamEncryptionOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.StopStreamEncryptionOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.StopStreamEncryptionInput, ...request.Option) *kinesis.StopStreamEncryptionOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.StopStreamEncryptionOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.StopStreamEncryptionInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateShardCount provides a mock function with given fields: _a0
func (_m *KinesisAPI) UpdateShardCount(_a0 *kinesis.UpdateShardCountInput) (*kinesis.UpdateShardCountOutput, error) {
	ret := _m.Called(_a0)

	var r0 *kinesis.UpdateShardCountOutput
	if rf, ok := ret.Get(0).(func(*kinesis.UpdateShardCountInput) *kinesis.UpdateShardCountOutput); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.UpdateShardCountOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*kinesis.UpdateShardCountInput) error); ok {
		r1 = rf(_a0)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateShardCountRequest provides a mock function with given fields: _a0
func (_m *KinesisAPI) UpdateShardCountRequest(_a0 *kinesis.UpdateShardCountInput) (*request.Request, *kinesis.UpdateShardCountOutput) {
	ret := _m.Called(_a0)

	var r0 *request.Request
	if rf, ok := ret.Get(0).(func(*kinesis.UpdateShardCountInput) *request.Request); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*request.Request)
		}
	}

	var r1 *kinesis.UpdateShardCountOutput
	if rf, ok := ret.Get(1).(func(*kinesis.UpdateShardCountInput) *kinesis.UpdateShardCountOutput); ok {
		r1 = rf(_a0)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*kinesis.UpdateShardCountOutput)
		}
	}

	return r0, r1
}

// UpdateShardCountWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) UpdateShardCountWithContext(_a0 aws.Context, _a1 *kinesis.UpdateShardCountInput, _a2 ...request.Option) (*kinesis.UpdateShardCountOutput, error) {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 *kinesis.UpdateShardCountOutput
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.UpdateShardCountInput, ...request.Option) *kinesis.UpdateShardCountOutput); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*kinesis.UpdateShardCountOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(aws.Context, *kinesis.UpdateShardCountInput, ...request.Option) error); ok {
		r1 = rf(_a0, _a1, _a2...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// WaitUntilStreamExists provides a mock function with given fields: _a0
func (_m *KinesisAPI) WaitUntilStreamExists(_a0 *kinesis.DescribeStreamInput) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamInput) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// WaitUntilStreamExistsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) WaitUntilStreamExistsWithContext(_a0 aws.Context, _a1 *kinesis.DescribeStreamInput, _a2 ...request.WaiterOption) error {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DescribeStreamInput, ...request.WaiterOption) error); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// WaitUntilStreamNotExists provides a mock function with given fields: _a0
func (_m *KinesisAPI) WaitUntilStreamNotExists(_a0 *kinesis.DescribeStreamInput) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(*kinesis.DescribeStreamInput) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// WaitUntilStreamNotExistsWithContext provides a mock function with given fields: _a0, _a1, _a2
func (_m *KinesisAPI) WaitUntilStreamNotExistsWithContext(_a0 aws.Context, _a1 *kinesis.DescribeStreamInput, _a2 ...request.WaiterOption) error {
	_va := make([]interface{}, len(_a2))
	for _i := range _a2 {
		_va[_i] = _a2[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, _a0, _a1)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	var r0 error
	if rf, ok := ret.Get(0).(func(aws.Context, *kinesis.DescribeStreamInput, ...request.WaiterOption) error); ok {
		r0 = rf(_a0, _a1, _a2...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
