#!/bin/bash

set -e

SKELETON=$1

TESTDIR="__tests__"

rm -rf rendered || echo "No existing rendered directory"

mkdir -p ./rendered

for file in $TESTDIR/*
do
    if [[ ! -f $file ]]; then
        continue
    fi

    base=$(basename "${file}")

    name=${base%.yaml}

    mkdir -p rendered/$name
    echo "installing ${name}"
    docker run --rm -v $PWD:/home/tcs docker.internal.justin.tv/devtools/tcs --disable-update-check skeleton install --dest rendered/$name --debug -f -i --data $TESTDIR/$base $SKELETON
    find rendered/$name -type f -exec chmod -w {} \;
done
