package ec2

import (
	"log"

	"code.justin.tv/foundation/xray/internal/plugins"
	"github.com/aws/aws-sdk-go/aws/ec2metadata"
	"github.com/aws/aws-sdk-go/aws/session"
)

func init() {
	if plugins.InstancePluginMetadata != nil && plugins.InstancePluginMetadata.IdentityDocument == nil {
		addPluginMetadata(plugins.InstancePluginMetadata)
	}
}

func addPluginMetadata(pluginmd *plugins.PluginMetadata) {
	client := ec2metadata.New(session.New())
	doc, err := client.GetInstanceIdentityDocument()
	if err != nil {
		log.Printf("Unable to read ec2 instance metadata %v", err)
		return
	}

	pluginmd.IdentityDocument = &doc
}
