package api

import (
	"encoding/json"
	"net/http"

	"github.com/zenazn/goji/web"
)

type vodIDs struct {
	VodIDs []int `json:"vod_ids"`
}

// EnabledVodIDs is exposed so that vod deletion can prevent deleting vods that are currently in an enabled playlist
func (T *Router) EnabledVodIDs(c web.C, w http.ResponseWriter, r *http.Request) {
	v := vodIDs{VodIDs: T.Backend.EnabledVodIDs()}

	err := json.NewEncoder(w).Encode(v)
	if err != nil {
		T.ServeError(w, r, err)
	}
}
