package api

import (
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/video/spectre/auth/authtest"
	"code.justin.tv/video/spectre/backend/backendtest"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/zenazn/goji/web"
)

func performEnabledVodIDsRequest(c web.C) *httptest.ResponseRecorder {
	router := Router{Backend: backendtest.NewBackend(), AuthHandler: authtest.NewHandler()}
	w := httptest.NewRecorder()

	r, _ := http.NewRequest("", "", nil)
	router.EnabledVodIDs(c, w, r)
	return w
}

func TestEnabledVodIDs(t *testing.T) {
	Convey("shows a valid channel", t, func() {
		c := web.C{URLParams: map[string]string{}}

		w := performEnabledVodIDsRequest(c)
		So(w.Code, ShouldEqual, http.StatusOK)
		So(w.Body.String(), ShouldContainSubstring, `{"vod_ids":[1]}`)
	})
}
