package api

// Manifest spectre url
// http://localhost:8000/v1/hls/36002799/medium/index-live.m3u8
// Manifest vod api url
// http://shim-493af0.sfo01.justin.tv:5151/api/internal/vods/6693409

// Chunk spectre url
// http://localhost:8000/v1/AUTH_system/vods_219d/vgbootcamp_15064386736_263589159/chunked/index-0000000014-fnlB.ts?start_offset=10214040&end_offset=12068095
// Chunk swift url

import (
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/video/spectre/backend"
	"code.justin.tv/video/spectre/util"
	"code.justin.tv/video/spectre/backend/backendtest"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/zenazn/goji/web"
)

const baseMediaURL = "http://localhost:8000/v1/hls"

func fakeRequestChanThatAlwaysFails(b backend.Backender) chan PlayheadRequest {
	requestChan := make(chan PlayheadRequest)
	go func() {
		for {
			request := <- requestChan
			request.DoneCh <- util.Nothing{}
		}
	}()
	return requestChan
}

func performShowManifestRequest(c web.C) *httptest.ResponseRecorder {
	backend := backendtest.NewBackend()
	// TODO: This needs to be passed in when there are tests that test for success too.
	requestChan := fakeRequestChanThatAlwaysFails(backend)
	router := Router{
		Backend:     backendtest.NewBackend(),
		RequestChan: requestChan,
	}
	w := httptest.NewRecorder()

	router.ShowManifest(c, w, &http.Request{})
	return w
}

func TestShowManifest(t *testing.T) {
	// TODO: make these work. they don't work because there is no way of setting playheads in test env yet
	// Convey("shows a valid channel", t, func() {
	// 	c := web.C{
	// 		URLParams: map[string]string{
	// 			"stream_id": "50_123_123",
	// 			"format":       "medium",
	// 		},
	// 	}

	// 	w := performShowManifestRequest(c)
	// 	So(w.Code, ShouldEqual, http.StatusOK)
	// 	So(w.Header().Get("Content-Type"), ShouldEqual, "application/x-mpegURL")
	// })

	// Convey("shows a valid channel without underscores after the id", t, func() {
	// 	c := web.C{
	// 		URLParams: map[string]string{
	// 			"stream_id": "50",
	// 			"format":       "medium",
	// 		},
	// 	}

	// 	w := performShowManifestRequest(c)
	// 	So(w.Code, ShouldEqual, http.StatusOK)
	// 	So(w.Header().Get("Content-Type"), ShouldEqual, "application/x-mpegURL")
	// })

	Convey("errors on inactive channels", t, func() {
		c := web.C{
			URLParams: map[string]string{
				"stream_id": "10_123_456",
				"format":    "medium",
			},
		}

		w := performShowManifestRequest(c)
		So(w.Code, ShouldEqual, http.StatusBadRequest)
	})

	// Convey("404s for invalid format", t, func() {
	// })
}
