package auth

import (
	"net/http"

	"code.justin.tv/common/goauthorization"
)

func AuthorizeCartmanToken(r *http.Request, channelID int) error {
	token, err := goauthorization.ParseToken(r)
	if err != nil {
		return err
	}

	return token.Validate(goauthorization.CapabilityClaims{
		"edit_channel": goauthorization.CapabilityClaim{
			"channel_id": channelID,
		},
	})
}
