-- +goose Up
-- SQL in section 'Up' is executed when this migration is applied

CREATE TABLE IF NOT EXISTS channels (
  id int primary key not null,
  enabled text,
  active_playlist_id integer DEFAULT -1,
  active_vod_index integer DEFAULT 0,
  active boolean,
  start_time timestamp default current_timestamp,
  x_media_sequence_index integer DEFAULT 0
);

CREATE TABLE IF NOT EXISTS playlists (
  id serial primary key not null,
  channel_id int,
  playlist json,
  version integer
);

CREATE INDEX playlist_channel_id_index ON playlists (channel_id);

INSERT INTO channels values (27061009, "", 1, 0, false, now());
INSERT INTO channels values (36002799, "asdf", 2, 0, false, now());
INSERT INTO channels values (27953914, "", 3, 0, false, now());
INSERT INTO channels values (992934, "", 4, 0, false, now());
INSERT INTO channels values (99148197, "", 5, 0, false, now());


INSERT INTO playlists values (DEFAULT, 27061009, '{"vod_ids": [6593768]}', 1); -- alephprime
INSERT INTO playlists values (DEFAULT, 36002799, '{"vod_ids": [2884155, 3949334, 7978800, 7983480, 8057509]}', 1); -- dathass
INSERT INTO playlists values (DEFAULT, 27953914, '{"vod_ids": [9400642, 9452866, 9987767, 10720338]}', 1); -- minigolf2000
INSERT INTO playlists values (DEFAULT, 992934, '{"vod_ids": [7294083,7500546,7297499,6450299]}', 1); -- bensw
INSERT INTO playlists values (DEFAULT, 99148197, '{"vod_ids": [10805109,10805692,10808227]}', 1); -- opltest1

-- +goose Down
-- SQL section 'Down' is executed when this migration is rolled back
DROP TABLE channels, playlists;
