package mocks

import "code.justin.tv/video/spectre/backend"
import "github.com/stretchr/testify/mock"

// MonitorBackend is an autogenerated mock type for the MonitorBackend type
type MonitorBackend struct {
	mock.Mock
}

// AllChannels provides a mock function with given fields:
func (_m *MonitorBackend) AllChannels() ([]backend.Channel, error) {
	ret := _m.Called()

	var r0 []backend.Channel
	if rf, ok := ret.Get(0).(func() []backend.Channel); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]backend.Channel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// BatchMarkActive provides a mock function with given fields: ids
func (_m *MonitorBackend) BatchMarkActive(ids []int) {
	_m.Called(ids)
}

// BatchMarkInactive provides a mock function with given fields: ids
func (_m *MonitorBackend) BatchMarkInactive(ids []int) {
	_m.Called(ids)
}

// GetPlaylist provides a mock function with given fields: channelID, id
func (_m *MonitorBackend) GetPlaylist(channelID int, id int) (*backend.Playlist, error) {
	ret := _m.Called(channelID, id)

	var r0 *backend.Playlist
	if rf, ok := ret.Get(0).(func(int, int) *backend.Playlist); ok {
		r0 = rf(channelID, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*backend.Playlist)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(int, int) error); ok {
		r1 = rf(channelID, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateChannel provides a mock function with given fields: values
func (_m *MonitorBackend) UpdateChannel(values backend.ChannelParams) error {
	ret := _m.Called(values)

	var r0 error
	if rf, ok := ret.Get(0).(func(backend.ChannelParams) error); ok {
		r0 = rf(values)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
