package mocks

import "github.com/stretchr/testify/mock"

import "time"

// Stats is an autogenerated mock type for the Stats type
type Stats struct {
	mock.Mock
}

// GaugeChange provides a mock function with given fields: bucket, step
func (_m *Stats) GaugeChange(bucket string, step int) {
	_m.Called(bucket, step)
}

// GaugeChangeUnsampled provides a mock function with given fields: bucket, step
func (_m *Stats) GaugeChangeUnsampled(bucket string, step int) {
	_m.Called(bucket, step)
}

// GaugeSet provides a mock function with given fields: bucket, value
func (_m *Stats) GaugeSet(bucket string, value uint) {
	_m.Called(bucket, value)
}

// GaugeSetUnsampled provides a mock function with given fields: bucket, value
func (_m *Stats) GaugeSetUnsampled(bucket string, value uint) {
	_m.Called(bucket, value)
}

// Incr provides a mock function with given fields: bucket
func (_m *Stats) Incr(bucket string) {
	_m.Called(bucket)
}

// IncrBy provides a mock function with given fields: bucket, step
func (_m *Stats) IncrBy(bucket string, step int) {
	_m.Called(bucket, step)
}

// IncrByUnsampled provides a mock function with given fields: bucket, step
func (_m *Stats) IncrByUnsampled(bucket string, step int) {
	_m.Called(bucket, step)
}

// IncrUnsampled provides a mock function with given fields: bucket
func (_m *Stats) IncrUnsampled(bucket string) {
	_m.Called(bucket)
}

// IntegerTiming provides a mock function with given fields: bucket, i
func (_m *Stats) IntegerTiming(bucket string, i int64) {
	_m.Called(bucket, i)
}

// IntegerTimingUnsampled provides a mock function with given fields: bucket, i
func (_m *Stats) IntegerTimingUnsampled(bucket string, i int64) {
	_m.Called(bucket, i)
}

// Timing provides a mock function with given fields: bucket, d
func (_m *Stats) Timing(bucket string, d time.Duration) {
	_m.Called(bucket, d)
}

// TimingUnsampled provides a mock function with given fields: bucket, d
func (_m *Stats) TimingUnsampled(bucket string, d time.Duration) {
	_m.Called(bucket, d)
}

// Unique provides a mock function with given fields: bucket, value
func (_m *Stats) Unique(bucket string, value string) {
	_m.Called(bucket, value)
}
