package mocks

import (
	"code.justin.tv/video/spectre/vods"
	"github.com/stretchr/testify/mock"
)

// Usher is an autogenerated mock type for the Usher type
type Usher struct {
	mock.Mock
}

// IsLive provides a mock function with given fields: channelId
func (_m *Usher) IsLive(channelId int) (bool, error) {
	ret := _m.Called(channelId)

	var r0 bool
	if rf, ok := ret.Get(0).(func(int) bool); ok {
		r0 = rf(channelId)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(int) error); ok {
		r1 = rf(channelId)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// LiveChannels provides a mock function with given fields:
func (_m *Usher) LiveChannels() (map[int]bool, error) {
	ret := _m.Called()

	var r0 map[int]bool
	if rf, ok := ret.Get(0).(func() map[int]bool); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int]bool)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RefreshStream provides a mock function with given fields: channelId
func (_m *Usher) RefreshStream(channelId int) bool {
	ret := _m.Called(channelId)

	var r0 bool
	if rf, ok := ret.Get(0).(func(int) bool); ok {
		r0 = rf(channelId)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// RefreshViewcount provides a mock function with given fields: channelId
func (_m *Usher) RefreshViewcount(channelId int) bool {
	ret := _m.Called(channelId)

	var r0 bool
	if rf, ok := ret.Get(0).(func(int) bool); ok {
		r0 = rf(channelId)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// SpectreChannels provides a mock function with given fields:
func (_m *Usher) SpectreChannels() (map[int]bool, error) {
	ret := _m.Called()

	var r0 map[int]bool
	if rf, ok := ret.Get(0).(func() map[int]bool); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int]bool)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// StreamDown provides a mock function with given fields: channelId
func (_m *Usher) StreamDown(channelId int) (bool, int) {
	ret := _m.Called(channelId)

	var r0 bool
	if rf, ok := ret.Get(0).(func(int) bool); ok {
		r0 = rf(channelId)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 int
	if rf, ok := ret.Get(1).(func(int) int); ok {
		r1 = rf(channelId)
	} else {
		r1 = ret.Get(1).(int)
	}

	return r0, r1
}

// StreamUp provides a mock function with given fields: channelId, vodId
func (_m *Usher) StreamUp(channelId int, vodId int) (bool, int) {
	ret := _m.Called(channelId, vodId)

	var r0 bool
	if rf, ok := ret.Get(0).(func(int, int) bool); ok {
		r0 = rf(channelId, vodId)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 int
	if rf, ok := ret.Get(1).(func(int, int) int); ok {
		r1 = rf(channelId, vodId)
	} else {
		r1 = ret.Get(1).(int)
	}

	return r0, r1
}

// Update provides a mock function with given fields: channelId, vodProps
func (_m *Usher) Update(channelId int, vodProps vods.Properties) bool {
	ret := _m.Called(channelId, vodProps)

	var r0 bool
	if rf, ok := ret.Get(0).(func(int, vods.Properties) bool); ok {
		r0 = rf(channelId, vodProps)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}
