package playhead

import (
	"code.justin.tv/video/spectre/swift"
	"code.justin.tv/video/spectre/vods"
)

func (p *Playhead) GetChunk(vodID int, format, uri string) ([]byte, error) {
	var chunkBytes []byte

	for _, vod := range [2]*vods.Vod{p.CurrentVod, p.NextVod} {
		if vod.ID == vodID {
			var err error

			chunkBytes, err = swift.GetChunk(vod.Properties.URI, vod.Properties.Origin, format, uri)
			if err == swift.ErrChunkNotFound {
				chunkBytes, err = swift.GetChunk(vod.Properties.URI, vod.Properties.Origin, "chunked", uri)
			}
			if err != nil {
				return []byte{}, err
			}
			break
		}
	}
	return chunkBytes, nil
}
