package swift

import (
	"testing"
	"time"

	. "github.com/smartystreets/goconvey/convey"
)

func TestUnmarshalManifest(t *testing.T) {

	originalManifest := []byte(`
#EXTM3U
#EXT-X-VERSION:3
#EXT-X-TARGETDURATION:4
#ID3-EQUIV-TDTG:2015-06-28T15:24:52
#EXT-X-PLAYLIST-TYPE:EVENT

#EXT-X-TWITCH-ELAPSED-SECS:0.0
#EXT-X-TWITCH-TOTAL-SECS:12630.373
#EXTINF:3.164,
index-0000000014-fnlB.ts?start_offset=0&end_offset=947143
#EXTINF:3.967,
index-0000000014-fnlB.ts?start_offset=947144&end_offset=2800635
#EXTINF:3.966,
index-0000000014-fnlB.ts?start_offset=2800636&end_offset=4655067
  `)

	Convey("correctly parses valid manifest", t, func() {
		totalDuration, _ := time.ParseDuration("11.097s")
		duration0, _ := time.ParseDuration("3.164s")
		duration1, _ := time.ParseDuration("3.967s")
		duration2, _ := time.ParseDuration("3.966s")

		startTime0 := 0 * time.Second
		startTime1 := startTime0 + duration0
		startTime2 := startTime1 + duration1

		vodID := 10

		expected := &Manifest{
			Duration: totalDuration,
			Chunks: []Chunk{
				Chunk{
					StartTime: startTime0,
					Duration:  duration0,
					Uri:       "index-0000000014-fnlB.ts?start_offset=0&end_offset=947143",
					VodID:     vodID,
				},
				Chunk{
					StartTime: startTime1,
					Duration:  duration1,
					Uri:       "index-0000000014-fnlB.ts?start_offset=947144&end_offset=2800635",
					VodID:     vodID,
				},
				Chunk{
					StartTime: startTime2,
					Duration:  duration2,
					Uri:       "index-0000000014-fnlB.ts?start_offset=2800636&end_offset=4655067",
					VodID:     vodID,
				},
			},
		}

		m, _ := unmarshalManifest(originalManifest, vodID)
		So(m, ShouldResemble, expected)
	})
}
