libforerunner
=============

A go library for interacting with Forerunner


Example
-------

```go
type Config struct {
	Port       int `description:"The Port that example should bind to"`
	Host       string
	DBPassword string `forerunner:"db-password,secret"`
}

func main() {
	conf := &Config{Port: 8080}

	// Initalize Forerunner:
	// Values set in the DefaultConfig will be saved for setting in the
	// future.
	fr, err := libforerunner.Init(&libforerunner.Options{
		DefaultConfig: conf,
	})
	if err != nil {
		log.Fatal(err)
	}

	// Load conf with any settings from consul/env/flags:
	if err := fr.GetConfig(conf); err != nil {
		log.Fatal(err)
	}

	conf2 := &Config{}
	fr.GetConfig(conf2)
	if err != nil {
		log.Fatal(err)
	}

	// This will return 8080 if no flags or consul settings are set:
	fmt.Printf("Port: %d", conf2.Port)
}
```
