package vods

import (
	"fmt"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestRepairVodPropertiesManifest(t *testing.T) {
	Convey("does not repair a valid archive manifest", t, func() {
		m := "heythere.m3u8"
		p := Properties{BroadcastType: "archive", Manifest: m}
		So(repairVodPropertiesManifest(p).Manifest, ShouldEqual, m)
	})
	Convey("does not repair a valid highlight manifest", t, func() {
		m := "heythere.m3u8"
		p := Properties{BroadcastType: "highlight", Manifest: m}
		So(repairVodPropertiesManifest(p).Manifest, ShouldEqual, m)
	})
	Convey("repairs an invalid archive manifest", t, func() {
		p := Properties{BroadcastType: "archive", Manifest: ""}
		So(repairVodPropertiesManifest(p).Manifest, ShouldEqual, "index-dvr.m3u8")
	})
	Convey("repairs an invalid highlight manifest", t, func() {
		p := Properties{ID: 123, BroadcastType: "highlight", Manifest: ""}
		So(repairVodPropertiesManifest(p).Manifest, ShouldEqual, fmt.Sprintf("highlight-%v.m3u8", p.ID))
	})
}
