job {
    name 'video-swift-management'
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'video/swift_management', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        shell 'rm -rf .manta/'
        shell 'manta -v -proxy -f .manta.json'
        shell 'ln -s .manta/ENV ENV'
        saveDeployArtifact 'video/swift_management', '.'
        saveDirtyDeployArtifact 'video/swift_management', '.'
    }
}

job {
    name "video-swift-management-deploy"
    using 'TEMPLATE-deploy'
    parameters {
        stringParam 'GIT_COMMIT'
    }
    steps {
        shell 'update-deployed-version -repo video/swift_management'
        shell 'courier deploy --repo video/swift_management --dir /home/jtv/swift_management --short-circuit'
    }
}
