define([
	],
	function() {
		var clickController = function(
			$scope,
			$document,
			$timeout,
			$animate,
			$position,
			smoothScroll
		) {
			var self = this;
			this.expanded = {
				'type': null,
				'idx': null
			}

			this.host = function(group, idx, event) {
				if(group === this.expanded.type && idx === this.expanded.idx) {
					this.expanded.type = null;
					this.expanded.idx = null;
				} else {
					this.expanded.type = group;
					this.expanded.idx = idx;
				}

				if(_.isUndefined(event)) {
					element = $(([
						'.',
						group,
						'-',
						idx
					]).join(''))[0]
				} else {
					element = event.currentTarget
				}

				$timeout(function() {
					angular.element(element).next().children().on('transitionend', function(argument) {
						smoothScroll($document[0], {
							stopOnUserScroll: true,
							offset: -$position.offset(angular.element(element)).top + 50,
						})

						angular.element(element).next().children().off('transitionend')
					})
				}, 0)
			}
		}

		return clickController;
	}
)