define([
	],
	function() {
		var dashboardController = function(
			$scope,
			smoothScroll
		) {
			var self = this;
			this.expanded = {}

			this.findHostFromEntity = function(entity) {
				var idx = _.chain($scope.data.groups)
					.find('type', entity.group)
					.get('hosts')
					.findIndex('ip', entity.host)
					.value()

				$scope.click.host(entity.group, idx)
			}

			this.findHostFromRing = function(entity) {
				var idx = _.chain($scope.data.groups)
					.find('type', entity.ring)
					.get('hosts')
					.findIndex(function(host) {
						return _.includes(host.ip, $scope.data.rings[entity.ring].id[entity.id].ip);
					})
					.value()

				$scope.click.host(entity.ring, idx)
			}
		}

		return dashboardController;
	}
)