define([
		'text!partials/swift.modal.hostSelection.html',
		'text!partials/swift.modal.driveCreation.html'
	],
	function(hostModal, driveModal) {
		var driveCreationController = function(
			$scope,
			$modal,
			$q,
			driveSvc
		) {
			var self = this;
			this.cancel = function(node) {
				driveSvc.put({
					host: node
				}).then(function(result) {
					$scope.data.refreshRedis();
				})
			}

			this.addMultiHost = function(nodes) {
				var hostSelection = $modal.open({
					template: hostModal,
					controller: ['$scope',
						'$modalInstance',
						'hosts',
						'DRIVE_TEMPLATES',
						function($scope,
							$modalInstance,
							hosts,
							DRIVE_TEMPLATES
						) {
							$scope.isUndefined = _.isUndefined;
							$scope.hosts = hosts;
							$scope.type = 'object';
							$scope.selected = {
								start: undefined,
								end: undefined,
							}

							$scope.select = function(index) {
								if(_.isUndefined($scope.selected.start)) {
									$scope.selected.start = index
								} else if(_.isUndefined($scope.selected.end)) {
									if(index > $scope.selected.start) {
										$scope.selected.end = index;
									} else {
										$scope.selected.end = $scope.selected.start;
										$scope.selected.start = index;
									}
								} else {
									$scope.selected.start = undefined;
									$scope.selected.end = undefined;
								}
							}

							$scope.types = {
								undefined: _.keys(DRIVE_TEMPLATES)
							};

							$scope.ok = function() {
								$modalInstance.close({
									hosts: _.slice($scope.hosts, $scope.selected.start, $scope.selected.end ? $scope.selected.end + 1 : $scope.selected.start + 1),
									drives: DRIVE_TEMPLATES[$scope.type],
									type: $scope.type
								});
							};

							$scope.cancel = function() {
								$modalInstance.dismiss();
							};
						}],
						resolve: {
							hosts: function() {
								return nodes
							}
						},
						windowClass: 'host-sel',
					});

				hostSelection.result.then(function(results) {
					return self.addDrive(results.hosts, results.drives, results.type)
				})
			}

			this.addDrive = function(nodes, drives, type, stage) {
				var addModal = $modal.open({
					template: driveModal,
					controller: ['$scope',
						'$modalInstance',
						'type',
						'drives',
						'hosts',
						'stage',
						'RING_TYPES',
						function($scope,
							$modalInstance,
							type,
							drives,
							hosts,
							stage,
							RING_TYPES
						) {
							$scope.active = {
								state: 'hosts'
							};

							$scope.hosts = hosts

							$scope.drive = {
								drives: drives,
								type: type,
								stage: stage,
								instant: false,
								fileSystem: 'xfs',
							};

							$scope.addHost = function(){
								$scope.hosts.push($scope.newHost);
								$scope.newHost = '';
							};

							$scope.addDrive = function(){
								$scope.drive.drives.push('/dev/' + $scope.newDrive);
								$scope.newDrive = '';
							};

							$scope.types = {
								undefined: RING_TYPES
							};

							$scope.ok = function() {
								$modalInstance.close(_.map($scope.hosts, function(host) {
									var copy = angular.copy($scope.drive);
									copy.host = host;

									return copy;
								}));
							};

							$scope.cancel = function() {
								$modalInstance.dismiss();
							};
						}],
						resolve: {
							type: function() {
								return type === 'uninitialized' ? undefined : type
							},
							hosts: function() {
								return _.pluck(nodes, 'name')
							},
							drives: function() {
								return _.isUndefined(drives) ? [] : drives
							},
							stage: function() {
								return _.isUndefined(stage) ? 'PREP' : stage
							},
						},
						windowClass: 'add-drive',
					});

				addModal.result.then(function(results) {
					return $q.all(_.map(results, function(drive) {
						return driveSvc.post(drive)
					}))
				}).then(function(result) {
					$scope.data.refreshRedis();
				})
			}
		}

		return driveCreationController;
	}
)